/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.client.ResponseMapGraphQlResponse;
import org.springframework.graphql.client.SyncGraphQlTransport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;

final class HttpSyncGraphQlTransport
implements SyncGraphQlTransport {
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final RestClient restClient;
    private final MediaType contentType;

    HttpSyncGraphQlTransport(RestClient restClient) {
        Assert.notNull((Object)restClient, (String)"RestClient is required");
        this.restClient = restClient;
        this.contentType = HttpSyncGraphQlTransport.initContentType(restClient);
    }

    private static MediaType initContentType(RestClient webClient) {
        HttpHeaders headers = new HttpHeaders();
        webClient.mutate().defaultHeaders(arg_0 -> ((HttpHeaders)headers).putAll(arg_0));
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType : MediaType.APPLICATION_JSON;
    }

    @Override
    public GraphQlResponse execute(GraphQlRequest request) {
        Map<String, Object> body = (Map<String, Object>)((RestClient.RequestBodySpec)this.restClient.post().contentType(this.contentType).accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_GRAPHQL_RESPONSE})).body(request.toMap()).retrieve().body(MAP_TYPE);
        return new ResponseMapGraphQlResponse(body != null ? body : Collections.emptyMap());
    }
}

