/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationState;
import io.micrometer.context.ContextSnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.dataloader.DataLoaderRegistry;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.execution.DataLoaderRegistrar;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.support.DefaultExecutionGraphQlResponse;
import reactor.core.publisher.Mono;

public class DefaultExecutionGraphQlService
implements ExecutionGraphQlService {
    private static final BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput> RESET_EXECUTION_ID_CONFIGURER = (executionInput, builder) -> builder.executionId(null).build();
    private final GraphQlSource graphQlSource;
    private final List<DataLoaderRegistrar> dataLoaderRegistrars = new ArrayList<DataLoaderRegistrar>();
    private boolean hasDataLoaderRegistrations;
    private final boolean isDefaultExecutionIdProvider;

    public DefaultExecutionGraphQlService(GraphQlSource graphQlSource) {
        this.graphQlSource = graphQlSource;
        this.isDefaultExecutionIdProvider = graphQlSource.graphQl().getIdProvider() == ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER;
    }

    public void addDataLoaderRegistrar(DataLoaderRegistrar registrar) {
        this.dataLoaderRegistrars.add(registrar);
        this.hasDataLoaderRegistrations = this.hasDataLoaderRegistrations || DefaultExecutionGraphQlService.hasRegistrations(registrar);
    }

    private static boolean hasRegistrations(DataLoaderRegistrar registrar) {
        DataLoaderRegistry registry = DataLoaderRegistry.newRegistry().build();
        registrar.registerDataLoaders(registry, GraphQLContext.newContext().build());
        return !registry.getDataLoaders().isEmpty();
    }

    @Override
    public final Mono<ExecutionGraphQlResponse> execute(ExecutionGraphQlRequest request) {
        return Mono.deferContextual(contextView -> {
            if (!this.isDefaultExecutionIdProvider && request.getExecutionId() == null) {
                request.configureExecutionInput(RESET_EXECUTION_ID_CONFIGURER);
            }
            ExecutionInput executionInput = request.toExecutionInput();
            GraphQLContext graphQLContext = executionInput.getGraphQLContext();
            ContextSnapshot.captureFrom((Object)contextView).updateContext((Object)graphQLContext);
            ExecutionInput updatedExecutionInput = this.hasDataLoaderRegistrations ? this.registerDataLoaders(executionInput) : executionInput;
            return Mono.fromFuture((CompletableFuture)this.graphQlSource.graphQl().executeAsync(updatedExecutionInput)).map(result -> new DefaultExecutionGraphQlResponse(updatedExecutionInput, (ExecutionResult)result));
        });
    }

    private ExecutionInput registerDataLoaders(ExecutionInput executionInput) {
        GraphQLContext graphQLContext = executionInput.getGraphQLContext();
        DataLoaderRegistry existingRegistry = executionInput.getDataLoaderRegistry();
        if (existingRegistry == DataLoaderDispatcherInstrumentationState.EMPTY_DATALOADER_REGISTRY) {
            DataLoaderRegistry newRegistry = DataLoaderRegistry.newRegistry().build();
            this.applyDataLoaderRegistrars(newRegistry, graphQLContext);
            executionInput = executionInput.transform(builder -> builder.dataLoaderRegistry(newRegistry));
        } else {
            this.applyDataLoaderRegistrars(existingRegistry, graphQLContext);
        }
        return executionInput;
    }

    private void applyDataLoaderRegistrars(DataLoaderRegistry registry, GraphQLContext graphQLContext) {
        this.dataLoaderRegistrars.forEach(registrar -> registrar.registerDataLoaders(registry, graphQLContext));
    }
}

