/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import java.util.Collection;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Window;
import org.springframework.graphql.data.pagination.ConnectionAdapter;
import org.springframework.graphql.data.pagination.ConnectionAdapterSupport;
import org.springframework.graphql.data.pagination.CursorStrategy;

public final class WindowConnectionAdapter
extends ConnectionAdapterSupport<ScrollPosition>
implements ConnectionAdapter {
    private static final long ZERO_OFFSET_ADJUSTMENT = ((OffsetScrollPosition)OffsetScrollPosition.positionFunction((long)0L).apply(0)).getOffset();

    public WindowConnectionAdapter(CursorStrategy<ScrollPosition> strategy) {
        super(strategy);
    }

    @Override
    public boolean supports(Class<?> containerType) {
        return Window.class.isAssignableFrom(containerType);
    }

    @Override
    public <T> Collection<T> getContent(Object container) {
        Window<T> window = this.window(container);
        return window.getContent();
    }

    @Override
    public boolean hasPrevious(Object container) {
        Window window = this.window(container);
        if (!window.isEmpty()) {
            ScrollPosition position = this.positionAt(window, 0);
            if (position instanceof KeysetScrollPosition) {
                KeysetScrollPosition keysetPosition = (KeysetScrollPosition)position;
                return keysetPosition.scrollsBackward() && window.hasNext();
            }
            return !position.isInitial();
        }
        return false;
    }

    @Override
    public boolean hasNext(Object container) {
        Window window = this.window(container);
        if (!window.isEmpty()) {
            ScrollPosition pos = this.positionAt(window, 0);
            if (pos instanceof KeysetScrollPosition) {
                KeysetScrollPosition keysetPos = (KeysetScrollPosition)pos;
                return keysetPos.scrollsForward() && window.hasNext();
            }
            return window.hasNext();
        }
        return false;
    }

    @Override
    public String cursorAt(Object container, int index) {
        ScrollPosition position = this.positionAt(this.window(container), index);
        return this.getCursorStrategy().toCursor(position);
    }

    private ScrollPosition positionAt(Window<?> window, int index) {
        ScrollPosition position = window.positionAt(index);
        if (ZERO_OFFSET_ADJUSTMENT > 0L && position instanceof OffsetScrollPosition) {
            OffsetScrollPosition offsetPos = (OffsetScrollPosition)position;
            position = offsetPos.advanceBy(-ZERO_OFFSET_ADJUSTMENT);
        }
        return position;
    }

    private <T> Window<T> window(Object container) {
        return (Window)container;
    }
}

