/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.idl.RuntimeWiring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.execution.SchemaReport;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class SchemaMappingInspector {
    private static final Log logger = LogFactory.getLog(SchemaMappingInspector.class);
    private final GraphQLSchema schema;
    private final Map<String, Map<String, DataFetcher>> dataFetchers;
    private final Set<String> inspectedTypes = new HashSet<String>();
    private final ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
    private final ReportBuilder reportBuilder = new ReportBuilder();
    @Nullable
    private SchemaReport report;

    private SchemaMappingInspector(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> dataFetchers) {
        Assert.notNull((Object)schema, (String)"GraphQLSchema is required");
        Assert.notNull(dataFetchers, (String)"DataFetcher map is required");
        this.schema = schema;
        this.dataFetchers = dataFetchers;
    }

    public SchemaReport getOrCreateReport() {
        if (this.report == null) {
            this.checkSchemaFields();
            this.checkDataFetcherRegistrations();
            this.report = this.reportBuilder.build();
        }
        return this.report;
    }

    private void checkSchemaFields() {
        this.checkFieldsContainer((GraphQLFieldsContainer)this.schema.getQueryType(), null);
        if (this.schema.isSupportingMutations()) {
            this.checkFieldsContainer((GraphQLFieldsContainer)this.schema.getMutationType(), null);
        }
        if (this.schema.isSupportingSubscriptions()) {
            this.checkFieldsContainer((GraphQLFieldsContainer)this.schema.getSubscriptionType(), null);
        }
    }

    private void checkFieldsContainer(GraphQLFieldsContainer fieldContainer, @Nullable ResolvableType resolvableType) {
        String typeName = fieldContainer.getName();
        Map dataFetcherMap = this.dataFetchers.getOrDefault(typeName, Collections.emptyMap());
        for (GraphQLFieldDefinition field : fieldContainer.getFieldDefinitions()) {
            String fieldName = field.getName();
            DataFetcher dataFetcher = (DataFetcher)dataFetcherMap.get(fieldName);
            if (dataFetcher != null) {
                this.checkField(fieldContainer, field, dataFetcher);
                continue;
            }
            if (resolvableType != null && this.hasProperty(resolvableType, fieldName)) continue;
            this.reportBuilder.unmappedField(FieldCoordinates.coordinates((String)typeName, (String)fieldName));
        }
    }

    private void checkField(GraphQLFieldsContainer parent, GraphQLFieldDefinition field, DataFetcher<?> dataFetcher) {
        GraphQLType outputType;
        ResolvableType resolvableType = ResolvableType.NONE;
        if (dataFetcher instanceof SelfDescribingDataFetcher) {
            SelfDescribingDataFetcher selfDescribingDataFetcher = (SelfDescribingDataFetcher)dataFetcher;
            resolvableType = selfDescribingDataFetcher.getReturnType();
        }
        if (this.isPaginatedType(outputType = this.unwrapIfNonNull((GraphQLType)field.getType()))) {
            outputType = this.getPaginatedType((GraphQLObjectType)outputType);
            resolvableType = this.nestForConnection(resolvableType);
        } else if (outputType instanceof GraphQLList) {
            GraphQLList listType = (GraphQLList)outputType;
            outputType = this.unwrapIfNonNull(listType.getWrappedType());
            resolvableType = this.nestForList(resolvableType, parent == this.schema.getSubscriptionType());
        } else {
            resolvableType = this.nestIfWrappedType(resolvableType);
        }
        if (this.addAndCheckIfAlreadyInspected(outputType)) {
            return;
        }
        if (!(outputType instanceof GraphQLFieldsContainer)) {
            if (SchemaMappingInspector.isNotScalarOrEnumType(outputType)) {
                FieldCoordinates coordinates = FieldCoordinates.coordinates((String)parent.getName(), (String)field.getName());
                this.addSkippedType(outputType, coordinates, "Unsupported schema type");
            }
            return;
        }
        GraphQLFieldsContainer fieldContainer = (GraphQLFieldsContainer)outputType;
        if (resolvableType.resolve(Object.class) == Object.class) {
            FieldCoordinates coordinates = FieldCoordinates.coordinates((String)parent.getName(), (String)field.getName());
            this.addSkippedType(outputType, coordinates, "No Java type information");
            return;
        }
        this.checkFieldsContainer(fieldContainer, resolvableType);
    }

    private GraphQLType unwrapIfNonNull(GraphQLType type) {
        GraphQLType graphQLType;
        if (type instanceof GraphQLNonNull) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)type;
            graphQLType = graphQLNonNull.getWrappedType();
        } else {
            graphQLType = type;
        }
        return graphQLType;
    }

    private boolean isPaginatedType(GraphQLType type) {
        GraphQLObjectType objectType;
        return type instanceof GraphQLObjectType && (objectType = (GraphQLObjectType)type).getName().endsWith("Connection") && objectType.getField("edges") != null && objectType.getField("pageInfo") != null;
    }

    private GraphQLType getPaginatedType(GraphQLObjectType type) {
        String name = type.getName().substring(0, type.getName().length() - 10);
        GraphQLType nodeType = this.schema.getType(name);
        Assert.state((nodeType != null ? 1 : 0) != 0, (String)("No node type for '" + type.getName() + "'"));
        return nodeType;
    }

    private ResolvableType nestForConnection(ResolvableType type) {
        if (type == ResolvableType.NONE) {
            return type;
        }
        type = this.nestIfWrappedType(type);
        if (logger.isDebugEnabled() && type.getGenerics().length != 1) {
            logger.debug((Object)("Expected Connection type to have a generic parameter: " + type));
        }
        return type.getNested(2);
    }

    private ResolvableType nestIfWrappedType(ResolvableType type) {
        Class clazz = type.resolve(Object.class);
        if (Optional.class.isAssignableFrom(clazz)) {
            if (logger.isDebugEnabled() && type.getGeneric(new int[]{0}).resolve() == null) {
                logger.debug((Object)("Expected Optional type to have a generic parameter: " + type));
            }
            return type.getNested(2);
        }
        ReactiveAdapter adapter = this.reactiveAdapterRegistry.getAdapter(clazz);
        if (adapter != null) {
            if (logger.isDebugEnabled() && adapter.isNoValue()) {
                logger.debug((Object)("Expected reactive/async return type that can produce value(s): " + type));
            }
            return type.getNested(2);
        }
        return type;
    }

    private ResolvableType nestForList(ResolvableType type, boolean subscription) {
        if (type == ResolvableType.NONE) {
            return type;
        }
        ReactiveAdapter adapter = this.reactiveAdapterRegistry.getAdapter(type.resolve(Object.class));
        if (adapter != null) {
            if (logger.isDebugEnabled() && adapter.isNoValue()) {
                logger.debug((Object)("Expected List compatible type: " + type));
            }
            type = type.getNested(2);
            if (adapter.isMultiValue() && !subscription) {
                return type;
            }
        }
        if (logger.isDebugEnabled() && !type.isArray() && type.getGenerics().length != 1) {
            logger.debug((Object)("Expected List compatible type: " + type));
        }
        return type.getNested(2);
    }

    private static String typeNameToString(GraphQLType type) {
        String string;
        if (type instanceof GraphQLNamedType) {
            GraphQLNamedType namedType = (GraphQLNamedType)type;
            string = namedType.getName();
        } else {
            string = type.toString();
        }
        return string;
    }

    private boolean addAndCheckIfAlreadyInspected(GraphQLType type) {
        GraphQLNamedOutputType outputType;
        return type instanceof GraphQLNamedOutputType && !this.inspectedTypes.add((outputType = (GraphQLNamedOutputType)type).getName());
    }

    private static boolean isNotScalarOrEnumType(GraphQLType type) {
        return !(type instanceof GraphQLScalarType) && !(type instanceof GraphQLEnumType);
    }

    private boolean hasProperty(ResolvableType resolvableType, String fieldName) {
        try {
            Class clazz = resolvableType.resolve(Object.class);
            return BeanUtils.getPropertyDescriptor((Class)clazz, (String)fieldName) != null;
        }
        catch (BeansException ex) {
            throw new IllegalStateException("Failed to introspect " + resolvableType + " for field '" + fieldName + "'", ex);
        }
    }

    private void addSkippedType(GraphQLType type, FieldCoordinates coordinates, String reason) {
        String typeName = SchemaMappingInspector.typeNameToString(type);
        this.reportBuilder.skippedType(type, coordinates);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Skipped '" + typeName + "': " + reason));
        }
    }

    private void checkDataFetcherRegistrations() {
        this.dataFetchers.forEach((typeName, registrations) -> registrations.forEach((fieldName, dataFetcher) -> {
            FieldCoordinates coordinates = FieldCoordinates.coordinates((String)typeName, (String)fieldName);
            if (this.schema.getFieldDefinition(coordinates) == null) {
                this.reportBuilder.unmappedRegistration(coordinates, (DataFetcher<?>)dataFetcher);
            }
        }));
    }

    public static SchemaReport inspect(GraphQLSchema schema, RuntimeWiring runtimeWiring) {
        return SchemaMappingInspector.inspect(schema, runtimeWiring.getDataFetchers());
    }

    public static SchemaReport inspect(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> dataFetchers) {
        return new SchemaMappingInspector(schema, dataFetchers).getOrCreateReport();
    }

    private class ReportBuilder {
        private final List<FieldCoordinates> unmappedFields = new ArrayList<FieldCoordinates>();
        private final Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations = new LinkedHashMap();
        private final List<SchemaReport.SkippedType> skippedTypes = new ArrayList<SchemaReport.SkippedType>();

        private ReportBuilder() {
        }

        public void unmappedField(FieldCoordinates coordinates) {
            this.unmappedFields.add(coordinates);
        }

        public void unmappedRegistration(FieldCoordinates coordinates, DataFetcher<?> dataFetcher) {
            this.unmappedRegistrations.put(coordinates, dataFetcher);
        }

        public void skippedType(GraphQLType type, FieldCoordinates coordinates) {
            this.skippedTypes.add(new DefaultSkippedType(type, coordinates));
        }

        public SchemaReport build() {
            return new DefaultSchemaReport(this.unmappedFields, this.unmappedRegistrations, this.skippedTypes);
        }
    }

    private record DefaultSkippedType(GraphQLType type, FieldCoordinates fieldCoordinates) implements SchemaReport.SkippedType
    {
        @Override
        public String toString() {
            return SchemaMappingInspector.typeNameToString(this.type);
        }
    }

    private class DefaultSchemaReport
    implements SchemaReport {
        private final List<FieldCoordinates> unmappedFields;
        private final Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations;
        private final List<SchemaReport.SkippedType> skippedTypes;

        public DefaultSchemaReport(List<FieldCoordinates> unmappedFields, Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations, List<SchemaReport.SkippedType> skippedTypes) {
            this.unmappedFields = Collections.unmodifiableList(unmappedFields);
            this.unmappedRegistrations = Collections.unmodifiableMap(unmappedRegistrations);
            this.skippedTypes = Collections.unmodifiableList(skippedTypes);
        }

        @Override
        public List<FieldCoordinates> unmappedFields() {
            return this.unmappedFields;
        }

        @Override
        public Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations() {
            return this.unmappedRegistrations;
        }

        @Override
        public List<SchemaReport.SkippedType> skippedTypes() {
            return this.skippedTypes;
        }

        @Override
        public GraphQLSchema schema() {
            return SchemaMappingInspector.this.schema;
        }

        @Override
        @Nullable
        public DataFetcher<?> dataFetcher(FieldCoordinates coordinates) {
            return (DataFetcher)SchemaMappingInspector.this.dataFetchers.getOrDefault(coordinates.getTypeName(), Collections.emptyMap()).get(coordinates.getFieldName());
        }

        public String toString() {
            return "GraphQL schema inspection:\n\tUnmapped fields: " + this.formatUnmappedFields() + "\n\tUnmapped registrations: " + this.unmappedRegistrations + "\n\tSkipped types: " + this.skippedTypes;
        }

        private String formatUnmappedFields() {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            this.unmappedFields.forEach(arg_0 -> DefaultSchemaReport.lambda$formatUnmappedFields$1((MultiValueMap)map, arg_0));
            return map.toString();
        }

        private static /* synthetic */ void lambda$formatUnmappedFields$1(MultiValueMap map, FieldCoordinates coordinates) {
            List fields = (List)map.computeIfAbsent((Object)coordinates.getTypeName(), s -> new ArrayList());
            fields.add(coordinates.getFieldName());
        }
    }
}

