/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQL;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.UnionTypeDefinition;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.CombinedWiringFactory;
import graphql.schema.idl.NoopWiringFactory;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.WiringFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.graphql.execution.AbstractGraphQlSourceBuilder;
import org.springframework.graphql.execution.ClassNameTypeResolver;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.MissingSchemaException;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SchemaMappingInspector;
import org.springframework.graphql.execution.SchemaReport;
import org.springframework.graphql.execution.TypeDefinitionConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class DefaultSchemaResourceGraphQlSourceBuilder
extends AbstractGraphQlSourceBuilder<GraphQlSource.SchemaResourceBuilder>
implements GraphQlSource.SchemaResourceBuilder {
    private static final Log logger = LogFactory.getLog(DefaultSchemaResourceGraphQlSourceBuilder.class);
    private final Set<Resource> schemaResources = new LinkedHashSet<Resource>();
    private final List<TypeDefinitionConfigurer> typeDefinitionConfigurers = new ArrayList<TypeDefinitionConfigurer>();
    private final List<RuntimeWiringConfigurer> runtimeWiringConfigurers = new ArrayList<RuntimeWiringConfigurer>();
    @Nullable
    private TypeResolver typeResolver;
    @Nullable
    private BiFunction<TypeDefinitionRegistry, RuntimeWiring, GraphQLSchema> schemaFactory;
    @Nullable
    private Consumer<SchemaReport> schemaReportConsumer;
    @Nullable
    private Consumer<GraphQLSchema> schemaReportRunner;

    DefaultSchemaResourceGraphQlSourceBuilder() {
    }

    @Override
    public DefaultSchemaResourceGraphQlSourceBuilder schemaResources(Resource ... resources) {
        this.schemaResources.addAll(Arrays.asList(resources));
        return this;
    }

    @Override
    public GraphQlSource.SchemaResourceBuilder configureTypeDefinitions(TypeDefinitionConfigurer configurer) {
        this.typeDefinitionConfigurers.add(configurer);
        return this;
    }

    @Override
    public DefaultSchemaResourceGraphQlSourceBuilder configureRuntimeWiring(RuntimeWiringConfigurer configurer) {
        this.runtimeWiringConfigurers.add(configurer);
        return this;
    }

    @Override
    public DefaultSchemaResourceGraphQlSourceBuilder defaultTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
        return this;
    }

    @Override
    public GraphQlSource.SchemaResourceBuilder inspectSchemaMappings(Consumer<SchemaReport> consumer) {
        this.schemaReportConsumer = consumer;
        return this;
    }

    @Override
    public DefaultSchemaResourceGraphQlSourceBuilder schemaFactory(BiFunction<TypeDefinitionRegistry, RuntimeWiring, GraphQLSchema> schemaFactory) {
        this.schemaFactory = schemaFactory;
        return this;
    }

    @Override
    protected GraphQLSchema initGraphQlSchema() {
        TypeDefinitionRegistry registry = this.schemaResources.stream().map(this::parse).reduce(TypeDefinitionRegistry::merge).orElseThrow(MissingSchemaException::new);
        for (TypeDefinitionConfigurer configurer : this.typeDefinitionConfigurers) {
            configurer.configure(registry);
        }
        logger.info((Object)("Loaded " + this.schemaResources.size() + " resource(s) in the GraphQL schema."));
        if (logger.isDebugEnabled()) {
            String resources = this.schemaResources.stream().map(Resource::getDescription).collect(Collectors.joining(","));
            logger.debug((Object)("Loaded GraphQL schema resources: (" + resources + ")"));
        }
        RuntimeWiring runtimeWiring = this.initRuntimeWiring();
        TypeResolver typeResolver = this.initTypeResolver();
        registry.types().values().forEach(def -> {
            if (def instanceof UnionTypeDefinition || def instanceof InterfaceTypeDefinition) {
                runtimeWiring.getTypeResolvers().putIfAbsent(def.getName(), typeResolver);
            }
        });
        if (this.schemaReportConsumer != null) {
            this.schemaReportRunner = schema -> {
                SchemaReport report = SchemaMappingInspector.inspect(schema, runtimeWiring);
                this.schemaReportConsumer.accept(report);
            };
        }
        return this.schemaFactory != null ? this.schemaFactory.apply(registry, runtimeWiring) : new SchemaGenerator().makeExecutableSchema(registry, runtimeWiring);
    }

    private TypeDefinitionRegistry parse(Resource schemaResource) {
        TypeDefinitionRegistry typeDefinitionRegistry;
        block9: {
            Assert.notNull((Object)schemaResource, (String)"'schemaResource' not provided");
            Assert.isTrue((boolean)schemaResource.exists(), (String)("'schemaResource' must exist: " + schemaResource));
            InputStream inputStream = schemaResource.getInputStream();
            try {
                typeDefinitionRegistry = new SchemaParser().parse(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Failed to load schema resource: " + schemaResource);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to parse schema resource: " + schemaResource, ex);
                }
            }
            inputStream.close();
        }
        return typeDefinitionRegistry;
    }

    private RuntimeWiring initRuntimeWiring() {
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        this.runtimeWiringConfigurers.forEach(configurer -> configurer.configure(builder));
        ArrayList<WiringFactory> factories = new ArrayList<WiringFactory>();
        WiringFactory factory = builder.build().getWiringFactory();
        if (!factory.getClass().equals(NoopWiringFactory.class)) {
            factories.add(factory);
        }
        this.runtimeWiringConfigurers.forEach(configurer -> configurer.configure(builder, factories));
        if (!factories.isEmpty()) {
            builder.wiringFactory((WiringFactory)new CombinedWiringFactory(factories));
        }
        return builder.build();
    }

    private TypeResolver initTypeResolver() {
        return this.typeResolver != null ? this.typeResolver : new ClassNameTypeResolver();
    }

    @Override
    protected void applyGraphQlConfigurers(GraphQL.Builder builder) {
        super.applyGraphQlConfigurers(builder);
        if (this.schemaReportRunner != null) {
            GraphQLSchema schema = builder.build().getGraphQLSchema();
            this.schemaReportRunner.accept(schema);
        }
    }
}

