/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import java.util.Collection;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Slice;
import org.springframework.graphql.data.pagination.ConnectionAdapter;
import org.springframework.graphql.data.pagination.ConnectionAdapterSupport;
import org.springframework.graphql.data.pagination.CursorStrategy;

public final class SliceConnectionAdapter
extends ConnectionAdapterSupport<ScrollPosition>
implements ConnectionAdapter {
    public SliceConnectionAdapter(CursorStrategy<ScrollPosition> strategy) {
        super(strategy);
    }

    @Override
    public boolean supports(Class<?> containerType) {
        return Slice.class.isAssignableFrom(containerType);
    }

    @Override
    public <T> Collection<T> getContent(Object container) {
        Slice<T> slice = this.slice(container);
        return slice.getContent();
    }

    @Override
    public boolean hasPrevious(Object container) {
        return this.slice(container).hasPrevious();
    }

    @Override
    public boolean hasNext(Object container) {
        return this.slice(container).hasNext();
    }

    @Override
    public String cursorAt(Object container, int index) {
        Slice slice = this.slice(container);
        OffsetScrollPosition position = ScrollPosition.offset((long)((long)slice.getNumber() * (long)slice.getSize() + (long)index));
        return this.getCursorStrategy().toCursor(position);
    }

    private <T> Slice<T> slice(Object container) {
        return (Slice)container;
    }
}

