/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.util.function.Consumer;
import org.springframework.graphql.client.AbstractDelegatingGraphQlClient;
import org.springframework.graphql.client.AbstractGraphQlClientBuilder;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.util.Assert;

final class DefaultTransportGraphQlClientBuilder
extends AbstractGraphQlClientBuilder<DefaultTransportGraphQlClientBuilder> {
    private final GraphQlTransport transport;

    DefaultTransportGraphQlClientBuilder(GraphQlTransport transport) {
        Assert.notNull((Object)transport, (String)"GraphQlTransport is required");
        this.transport = transport;
    }

    @Override
    public GraphQlClient build() {
        GraphQlClient client = this.buildGraphQlClient(this.transport);
        return new DefaultTransportGraphQlClient(client, this.transport, this.getBuilderInitializer());
    }

    private static class DefaultTransportGraphQlClient
    extends AbstractDelegatingGraphQlClient {
        private final GraphQlTransport transport;
        private final Consumer<AbstractGraphQlClientBuilder<?>> builderInitializer;

        DefaultTransportGraphQlClient(GraphQlClient graphQlClient, GraphQlTransport transport, Consumer<AbstractGraphQlClientBuilder<?>> builderInitializer) {
            super(graphQlClient);
            Assert.notNull((Object)transport, (String)"GraphQlTransport is required");
            Assert.notNull(builderInitializer, (String)"'builderInitializer' is required");
            this.transport = transport;
            this.builderInitializer = builderInitializer;
        }

        public DefaultTransportGraphQlClientBuilder mutate() {
            DefaultTransportGraphQlClientBuilder builder = new DefaultTransportGraphQlClientBuilder(this.transport);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

