/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.util.List;
import java.util.stream.Stream;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.graphql.server.support.GraphQlWebSocketMessage;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;

final class CodecDelegate {
    private static final ResolvableType MESSAGE_TYPE = ResolvableType.forClass(GraphQlWebSocketMessage.class);
    private final CodecConfigurer codecConfigurer;
    private final Decoder<?> decoder;
    private final Encoder<?> encoder;

    CodecDelegate(CodecConfigurer configurer) {
        Assert.notNull((Object)configurer, (String)"CodecConfigurer is required");
        this.codecConfigurer = configurer;
        this.decoder = CodecDelegate.findJsonDecoder(configurer);
        this.encoder = CodecDelegate.findJsonEncoder(configurer);
    }

    static Encoder<?> findJsonEncoder(CodecConfigurer configurer) {
        return CodecDelegate.findJsonEncoder(configurer.getWriters().stream().filter(writer -> writer instanceof EncoderHttpMessageWriter).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()));
    }

    static Decoder<?> findJsonDecoder(CodecConfigurer configurer) {
        return CodecDelegate.findJsonDecoder(configurer.getReaders().stream().filter(reader -> reader instanceof DecoderHttpMessageReader).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()));
    }

    static Encoder<?> findJsonEncoder(List<Encoder<?>> encoders) {
        return CodecDelegate.findJsonEncoder(encoders.stream());
    }

    static Decoder<?> findJsonDecoder(List<Decoder<?>> decoders) {
        return CodecDelegate.findJsonDecoder(decoders.stream());
    }

    private static Encoder<?> findJsonEncoder(Stream<Encoder<?>> stream) {
        return stream.filter(encoder -> encoder.canEncode(MESSAGE_TYPE, (MimeType)MediaType.APPLICATION_JSON)).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Encoder"));
    }

    private static Decoder<?> findJsonDecoder(Stream<Decoder<?>> decoderStream) {
        return decoderStream.filter(decoder -> decoder.canDecode(MESSAGE_TYPE, (MimeType)MediaType.APPLICATION_JSON)).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Decoder"));
    }

    public CodecConfigurer getCodecConfigurer() {
        return this.codecConfigurer;
    }

    public <T> WebSocketMessage encode(WebSocketSession session, GraphQlWebSocketMessage message) {
        DataBuffer buffer = this.encoder.encodeValue((Object)message, session.bufferFactory(), MESSAGE_TYPE, MimeTypeUtils.APPLICATION_JSON, null);
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, buffer);
    }

    public GraphQlWebSocketMessage decode(WebSocketMessage webSocketMessage) {
        DataBuffer buffer = DataBufferUtils.retain((DataBuffer)webSocketMessage.getPayload());
        return (GraphQlWebSocketMessage)this.decoder.decode(buffer, MESSAGE_TYPE, null, null);
    }
}

