/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLTypeVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Sort;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.querydsl.binding.QuerydslBinderCustomizer;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.graphql.data.query.AutoRegistrationRuntimeWiringConfigurer;
import org.springframework.graphql.data.query.AutoRegistrationTypeVisitor;
import org.springframework.graphql.data.query.PropertySelection;
import org.springframework.graphql.data.query.QueryByExampleDataFetcher;
import org.springframework.graphql.data.query.RepositoryUtils;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class QuerydslDataFetcher<T> {
    private static final Log logger = LogFactory.getLog(QueryByExampleDataFetcher.class);
    private static final QuerydslPredicateBuilder BUILDER = new QuerydslPredicateBuilder(DefaultConversionService.getSharedInstance(), (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    private static final QuerydslBinderCustomizer NO_OP_BINDER_CUSTOMIZER = (bindings, root) -> {};
    private final TypeInformation<T> domainType;
    private final QuerydslBinderCustomizer<EntityPath<?>> customizer;

    QuerydslDataFetcher(TypeInformation<T> domainType, QuerydslBinderCustomizer<EntityPath<?>> customizer) {
        this.domainType = domainType;
        this.customizer = customizer;
    }

    protected Predicate buildPredicate(DataFetchingEnvironment environment) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        QuerydslBindings bindings = new QuerydslBindings();
        EntityPath path = SimpleEntityPathResolver.INSTANCE.createPath(this.domainType.getType());
        this.customizer.customize(bindings, path);
        for (Map.Entry entry : environment.getArguments().entrySet()) {
            Object value = entry.getValue();
            List values = value instanceof List ? (List)value : Collections.singletonList(value);
            parameters.put(entry.getKey(), values);
        }
        return BUILDER.getPredicate(this.domainType, (MultiValueMap)parameters, bindings);
    }

    protected boolean requiresProjection(Class<?> resultType) {
        return !resultType.equals(this.domainType.getType());
    }

    protected Collection<String> buildPropertyPaths(DataFetchingFieldSelectionSet selection, Class<?> resultType) {
        if (this.domainType.getType().equals(resultType) || this.domainType.getType().isAssignableFrom(resultType) || this.domainType.isSubTypeOf(resultType)) {
            return PropertySelection.create(this.domainType, selection).toList();
        }
        return Collections.emptyList();
    }

    public static <T> Builder<T, T> builder(QuerydslPredicateExecutor<T> executor) {
        return new Builder(executor, RepositoryUtils.getDomainType(executor));
    }

    public static <T> ReactiveBuilder<T, T> builder(ReactiveQuerydslPredicateExecutor<T> executor) {
        return new ReactiveBuilder(executor, RepositoryUtils.getDomainType(executor));
    }

    public static RuntimeWiringConfigurer autoRegistrationConfigurer(List<QuerydslPredicateExecutor<?>> executors, List<ReactiveQuerydslPredicateExecutor<?>> reactiveExecutors) {
        Object builder;
        String typeName;
        HashMap factories = new HashMap();
        for (QuerydslPredicateExecutor<?> querydslPredicateExecutor : executors) {
            typeName = RepositoryUtils.getGraphQlTypeName(querydslPredicateExecutor);
            if (typeName == null) continue;
            builder = QuerydslDataFetcher.builder(querydslPredicateExecutor).customizer(QuerydslDataFetcher.customizer(querydslPredicateExecutor));
            factories.put(typeName, single -> single != false ? builder.single() : builder.many());
        }
        for (ReactiveQuerydslPredicateExecutor reactiveQuerydslPredicateExecutor : reactiveExecutors) {
            typeName = RepositoryUtils.getGraphQlTypeName(reactiveQuerydslPredicateExecutor);
            if (typeName == null) continue;
            builder = QuerydslDataFetcher.builder(reactiveQuerydslPredicateExecutor).customizer(QuerydslDataFetcher.customizer(reactiveQuerydslPredicateExecutor));
            factories.put(typeName, arg_0 -> QuerydslDataFetcher.lambda$autoRegistrationConfigurer$2((ReactiveBuilder)builder, arg_0));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Auto-registration candidate typeNames " + factories.keySet()));
        }
        return new AutoRegistrationRuntimeWiringConfigurer(factories);
    }

    @Deprecated
    public static GraphQLTypeVisitor autoRegistrationTypeVisitor(List<QuerydslPredicateExecutor<?>> executors, List<ReactiveQuerydslPredicateExecutor<?>> reactiveExecutors) {
        Object builder;
        String typeName;
        HashMap factories = new HashMap();
        for (QuerydslPredicateExecutor<?> querydslPredicateExecutor : executors) {
            typeName = RepositoryUtils.getGraphQlTypeName(querydslPredicateExecutor);
            if (typeName == null) continue;
            builder = QuerydslDataFetcher.builder(querydslPredicateExecutor).customizer(QuerydslDataFetcher.customizer(querydslPredicateExecutor));
            factories.put(typeName, single -> single != false ? builder.single() : builder.many());
        }
        for (ReactiveQuerydslPredicateExecutor reactiveQuerydslPredicateExecutor : reactiveExecutors) {
            typeName = RepositoryUtils.getGraphQlTypeName(reactiveQuerydslPredicateExecutor);
            if (typeName == null) continue;
            builder = QuerydslDataFetcher.builder(reactiveQuerydslPredicateExecutor).customizer(QuerydslDataFetcher.customizer(reactiveQuerydslPredicateExecutor));
            factories.put(typeName, arg_0 -> QuerydslDataFetcher.lambda$autoRegistrationTypeVisitor$4((ReactiveBuilder)builder, arg_0));
        }
        return new AutoRegistrationTypeVisitor(factories);
    }

    private static QuerydslBinderCustomizer customizer(Object executor) {
        return executor instanceof QuerydslBinderCustomizer ? (QuerydslBinderCustomizer)executor : NO_OP_BINDER_CUSTOMIZER;
    }

    private static /* synthetic */ DataFetcher lambda$autoRegistrationTypeVisitor$4(ReactiveBuilder builder, Boolean single) {
        return single != false ? builder.single() : builder.many();
    }

    private static /* synthetic */ DataFetcher lambda$autoRegistrationConfigurer$2(ReactiveBuilder builder, Boolean single) {
        return single != false ? builder.single() : builder.many();
    }

    private static class ReactiveManyEntityFetcher<T, R>
    extends QuerydslDataFetcher<T>
    implements DataFetcher<Flux<R>> {
        private final ReactiveQuerydslPredicateExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ReactiveManyEntityFetcher(ReactiveQuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(domainType, customizer);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        public Flux<R> get(DataFetchingEnvironment env) {
            return (Flux)this.executor.findBy(this.buildPredicate(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.all();
            });
        }
    }

    private static class ReactiveSingleEntityFetcher<T, R>
    extends QuerydslDataFetcher<T>
    implements DataFetcher<Mono<R>> {
        private final ReactiveQuerydslPredicateExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ReactiveSingleEntityFetcher(ReactiveQuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(domainType, customizer);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        public Mono<R> get(DataFetchingEnvironment env) {
            return (Mono)this.executor.findBy(this.buildPredicate(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.first();
            });
        }
    }

    private static class ManyEntityFetcher<T, R>
    extends QuerydslDataFetcher<T>
    implements DataFetcher<Iterable<R>> {
        private final QuerydslPredicateExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ManyEntityFetcher(QuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(domainType, customizer);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        public Iterable<R> get(DataFetchingEnvironment env) {
            return (Iterable)this.executor.findBy(this.buildPredicate(env), query -> {
                FluentQuery.FetchableFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.all();
            });
        }
    }

    private static class SingleEntityFetcher<T, R>
    extends QuerydslDataFetcher<T>
    implements DataFetcher<R> {
        private final QuerydslPredicateExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        SingleEntityFetcher(QuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            super(domainType, customizer);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        public R get(DataFetchingEnvironment env) {
            return ((Optional)this.executor.findBy(this.buildPredicate(env), query -> {
                Class<R> resultType;
                FluentQuery.FetchableFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(resultType = this.resultType) ? queryToUse.as(resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), resultType));
                return queryToUse.first();
            })).orElse(null);
        }
    }

    public static class ReactiveBuilder<T, R> {
        private final ReactiveQuerydslPredicateExecutor<T> executor;
        private final TypeInformation<T> domainType;
        private final Class<R> resultType;
        private final Sort sort;
        private final QuerydslBinderCustomizer<? extends EntityPath<T>> customizer;

        ReactiveBuilder(ReactiveQuerydslPredicateExecutor<T> executor, Class<R> domainType) {
            this(executor, (TypeInformation<T>)ClassTypeInformation.from(domainType), domainType, Sort.unsorted(), (QuerydslBinderCustomizer<EntityPath<T>>)NO_OP_BINDER_CUSTOMIZER);
        }

        ReactiveBuilder(ReactiveQuerydslPredicateExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            this.executor = executor;
            this.domainType = domainType;
            this.resultType = resultType;
            this.sort = sort;
            this.customizer = customizer;
        }

        public <P> ReactiveBuilder<T, P> projectAs(Class<P> projectionType) {
            Assert.notNull(projectionType, (String)"Projection type must not be null");
            return new ReactiveBuilder<T, P>(this.executor, this.domainType, projectionType, this.sort, this.customizer);
        }

        public ReactiveBuilder<T, R> sortBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, sort, this.customizer);
        }

        public ReactiveBuilder<T, R> customizer(QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            Assert.notNull(customizer, (String)"QuerydslBinderCustomizer must not be null");
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, this.sort, customizer);
        }

        public DataFetcher<Mono<R>> single() {
            return new ReactiveSingleEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort, this.customizer);
        }

        public DataFetcher<Flux<R>> many() {
            return new ReactiveManyEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort, this.customizer);
        }
    }

    public static class Builder<T, R> {
        private final QuerydslPredicateExecutor<T> executor;
        private final ClassTypeInformation<T> domainType;
        private final Class<R> resultType;
        private final Sort sort;
        private final QuerydslBinderCustomizer<? extends EntityPath<T>> customizer;

        Builder(QuerydslPredicateExecutor<T> executor, Class<R> domainType) {
            this(executor, ClassTypeInformation.from(domainType), domainType, Sort.unsorted(), NO_OP_BINDER_CUSTOMIZER);
        }

        Builder(QuerydslPredicateExecutor<T> executor, ClassTypeInformation<T> domainType, Class<R> resultType, Sort sort, QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            this.executor = executor;
            this.domainType = domainType;
            this.resultType = resultType;
            this.sort = sort;
            this.customizer = customizer;
        }

        public <P> Builder<T, P> projectAs(Class<P> projectionType) {
            Assert.notNull(projectionType, (String)"Projection type must not be null");
            return new Builder<T, P>(this.executor, this.domainType, projectionType, this.sort, this.customizer);
        }

        public Builder<T, R> sortBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, sort, this.customizer);
        }

        public Builder<T, R> customizer(QuerydslBinderCustomizer<? extends EntityPath<T>> customizer) {
            Assert.notNull(customizer, (String)"QuerydslBinderCustomizer must not be null");
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, this.sort, customizer);
        }

        public DataFetcher<R> single() {
            return new SingleEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort, this.customizer);
        }

        public DataFetcher<Iterable<R>> many() {
            return new ManyEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort, this.customizer);
        }
    }
}

