/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.config;

import java.util.ArrayList;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.yarn.am.allocate.DefaultContainerAllocator;
import org.springframework.yarn.am.container.DefaultContainerLauncher;
import org.springframework.yarn.am.monitor.DefaultContainerMonitor;
import org.springframework.yarn.batch.am.BatchAppmaster;
import org.springframework.yarn.batch.support.YarnJobLauncher;
import org.springframework.yarn.config.YarnNamespaceUtils;
import org.springframework.yarn.container.CommandLineContainerRunner;
import org.springframework.yarn.launch.LaunchCommandsFactoryBean;
import org.springframework.yarn.support.ParsingUtils;
import org.w3c.dom.Element;

public class BatchMasterParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder defBuilder;
        Element containerRunnerElement;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(BatchAppmaster.class);
        Element containerCommandElement = DomUtils.getChildElementByTagName((Element)element, (String)"container-command");
        if (containerCommandElement != null) {
            String textContent = containerCommandElement.getTextContent();
            String command = ParsingUtils.extractRunnableCommand((String)textContent);
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(command);
            builder.addPropertyValue("commands", commands);
        }
        if ((containerRunnerElement = DomUtils.getChildElementByTagName((Element)element, (String)"container-runner")) != null && containerCommandElement == null) {
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(LaunchCommandsFactoryBean.class);
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)containerRunnerElement, (String)"command");
            defBuilder.addPropertyValue("runner", CommandLineContainerRunner.class);
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)containerRunnerElement, (String)"context-file", (boolean)false, (String)"container-context.xml");
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)containerRunnerElement, (String)"bean-name", (boolean)false, (String)"yarnContainer");
            YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)containerRunnerElement, (String)"arguments");
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)containerRunnerElement, (String)"stdout", (boolean)false, (String)"<LOG_DIR>/Container.stdout");
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)containerRunnerElement, (String)"stderr", (boolean)false, (String)"<LOG_DIR>/Container.stderr");
            AbstractBeanDefinition beanDef = defBuilder.getBeanDefinition();
            String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, beanName));
            builder.addPropertyReference("commands", beanName);
        }
        defBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultContainerAllocator.class);
        defBuilder.addPropertyReference("configuration", "yarnConfiguration");
        Element allocElement = DomUtils.getChildElementByTagName((Element)element, (String)"container-allocator");
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)element, (String)"environment", (String)"yarnEnvironment");
        if (allocElement != null) {
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)allocElement, (String)"hostname");
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)allocElement, (String)"virtualcores");
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)allocElement, (String)"memory");
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)allocElement, (String)"priority");
        }
        AbstractBeanDefinition beanDef = defBuilder.getBeanDefinition();
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, beanName));
        builder.addPropertyReference("allocator", beanName);
        defBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultContainerLauncher.class);
        Element launchElement = DomUtils.getChildElementByTagName((Element)element, (String)"container-launcher");
        if (launchElement != null) {
            YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)allocElement, (String)"username");
        }
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)element, (String)"configuration", (String)"yarnConfiguration");
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)element, (String)"environment", (String)"yarnEnvironment");
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)element, (String)"resource-localizer", (String)"yarnLocalresources");
        beanDef = defBuilder.getBeanDefinition();
        beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, beanName));
        builder.addPropertyReference("launcher", beanName);
        defBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultContainerMonitor.class);
        beanDef = defBuilder.getBeanDefinition();
        beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, beanName));
        builder.addPropertyReference("monitor", beanName);
        defBuilder = BeanDefinitionBuilder.genericBeanDefinition(YarnJobLauncher.class);
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)element, (String)"job-launcher");
        YarnNamespaceUtils.setCSVReferenceProperty((Element)element, (BeanDefinitionBuilder)defBuilder, (String)"jobs", (String)"jobs");
        YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)defBuilder, (Element)element, (String)"job-name", (boolean)false, (String)"job");
        beanDef = defBuilder.getBeanDefinition();
        beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, beanName));
        builder.addPropertyReference("yarnJobLauncher", beanName);
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"resource-localizer", (String)"yarnLocalresources");
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"configuration", (String)"yarnConfiguration");
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"environment", (String)"yarnEnvironment");
        return builder.getBeanDefinition();
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)name)) {
            name = "yarnAppmaster";
        }
        return name;
    }
}

