/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.springframework.data.solr.core.schema.ContentParser;
import org.springframework.data.solr.core.schema.MappingJacksonRequestContentParser;
import org.springframework.data.solr.core.schema.MappingJacksonResponseParser;
import org.springframework.data.solr.core.schema.SolrJsonResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

public class SolrJsonRequest
extends SolrRequest<SolrJsonResponse> {
    private static final long serialVersionUID = 5786008418321490550L;
    private ModifiableSolrParams params = new ModifiableSolrParams();
    private List<ContentStream> contentStream = Collections.emptyList();
    @Nullable
    private ContentParser contentParser;

    public SolrJsonRequest(SolrRequest.METHOD method, String path) {
        super(method, path);
        this.setResponseParser(new MappingJacksonResponseParser());
        this.setContentParser(new MappingJacksonRequestContentParser());
    }

    private void setContentParser(@Nullable ContentParser requestParser) {
        this.contentParser = requestParser != null ? requestParser : new MappingJacksonRequestContentParser();
    }

    @Nullable
    public ContentParser getContentParser() {
        return this.contentParser;
    }

    public SolrParams getParams() {
        return this.params;
    }

    public Collection<ContentStream> getContentStreams() throws IOException {
        return Collections.unmodifiableCollection(this.contentStream);
    }

    public void addContentToStream(Object content) {
        this.contentStream = new ArrayList<ContentStream>(this.contentStream);
        this.contentStream.add(this.getContentParser().parse(content));
    }

    public String toString() {
        return this.getMethod().toString() + " " + this.getPath() + "\r\n" + this.quietlyReadContentStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String quietlyReadContentStreams() {
        StringBuilder sb = new StringBuilder();
        if (this.contentStream != null) {
            for (ContentStream stream : this.contentStream) {
                InputStream ioStream = null;
                try {
                    ioStream = stream.getStream();
                    sb.append(StreamUtils.copyToString((InputStream)ioStream, (Charset)Charset.forName("UTF-8")));
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    if (ioStream == null) continue;
                    try {
                        ioStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return sb.toString();
    }

    protected SolrJsonResponse createResponse(SolrClient client) {
        return new SolrJsonResponse();
    }
}

