/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.HttpMethods;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.HttpRequestMethodNotSupportedException;

public class RootResourceInformation {
    private final @Nullable ResourceMetadata resourceMetadata;
    private final @Nullable RepositoryInvoker invoker;
    private final @Nullable PersistentEntity<?, ?> persistentEntity;

    public RootResourceInformation(@Nullable ResourceMetadata metadata, PersistentEntity<?, ?> entity, RepositoryInvoker invoker) {
        this.resourceMetadata = metadata;
        if (this.resourceMetadata == null || !this.resourceMetadata.isExported()) {
            this.invoker = null;
            this.persistentEntity = null;
        } else {
            this.invoker = invoker;
            this.persistentEntity = entity;
        }
    }

    public Class<?> getDomainType() {
        return this.getResourceMetadata().getDomainType();
    }

    public ResourceMetadata getResourceMetadata() {
        Assert.state((this.resourceMetadata != null ? 1 : 0) != 0, (String)"ResourceMetadata is null");
        return this.resourceMetadata;
    }

    public SearchResourceMappings getSearchMappings() {
        return this.getResourceMetadata().getSearchResourceMappings();
    }

    public @Nullable RepositoryInvoker getInvoker() {
        return this.invoker;
    }

    public RepositoryInvoker getRequiredInvoker() {
        Assert.state((this.invoker != null ? 1 : 0) != 0, (String)"RepositoryInvoker is null");
        return this.invoker;
    }

    public PersistentEntity<?, ?> getPersistentEntity() {
        Assert.state((this.persistentEntity != null ? 1 : 0) != 0, (String)"PersistentEntity is null");
        return this.persistentEntity;
    }

    public SupportedHttpMethods getSupportedMethods() {
        return this.getResourceMetadata().getSupportedHttpMethods();
    }

    public void verifySupportedMethod(HttpMethod httpMethod, ResourceType resourceType) throws HttpRequestMethodNotSupportedException, ResourceNotFoundException {
        Assert.notNull((Object)httpMethod, (String)"HTTP method must not be null");
        Assert.notNull((Object)resourceType, (String)"EntityRepresentationModel type must not be null");
        if (!this.getResourceMetadata().isExported()) {
            throw new ResourceNotFoundException();
        }
        SupportedHttpMethods httpMethods = this.getResourceMetadata().getSupportedHttpMethods();
        HttpMethods supportedMethods = httpMethods.getMethodsFor(resourceType);
        if (!supportedMethods.contains(httpMethod)) {
            RootResourceInformation.reject(httpMethod, supportedMethods);
        }
    }

    public void verifySupportedMethod(HttpMethod httpMethod, PersistentProperty<?> property) throws HttpRequestMethodNotSupportedException {
        Assert.notNull((Object)httpMethod, (String)"HTTP method must not be null");
        Assert.notNull(property, (String)"EntityRepresentationModel type must not be null");
        if (!this.getResourceMetadata().isExported()) {
            throw new ResourceNotFoundException();
        }
        SupportedHttpMethods httpMethods = this.getResourceMetadata().getSupportedHttpMethods();
        HttpMethods supportedMethods = httpMethods.getMethodsFor(property);
        if (!supportedMethods.contains(httpMethod)) {
            RootResourceInformation.reject(httpMethod, supportedMethods);
        }
    }

    public void verifyPutForCreation() throws HttpRequestMethodNotSupportedException {
        SupportedHttpMethods supportedHttpMethods = this.getResourceMetadata().getSupportedHttpMethods();
        if (!supportedHttpMethods.allowsPutForCreation()) {
            RootResourceInformation.reject(HttpMethod.PUT, supportedHttpMethods.getMethodsFor(ResourceType.ITEM));
        }
    }

    public Link resourceLink(EntityModel<?> resource) {
        ResourceMetadata repoMapping = this.getResourceMetadata();
        Link selfLink = resource.getRequiredLink(IanaLinkRelations.SELF);
        return Link.of((String)selfLink.getHref(), (LinkRelation)repoMapping.getItemResourceRel());
    }

    private static void reject(HttpMethod method, HttpMethods supported) throws HttpRequestMethodNotSupportedException {
        Set stringMethods = supported.butWithout(new HttpMethod[]{method}).stream().map(HttpMethod::name).collect(Collectors.toSet());
        throw new HttpRequestMethodNotSupportedException(method.name(), stringMethods);
    }
}

