/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Assignment;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.Where;
import org.springframework.data.relational.core.sql.render.AssignmentVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.FromTableVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.WhereClauseVisitor;

class UpdateStatementVisitor
extends DelegatingVisitor
implements PartRenderer {
    private final StringBuilder builder = new StringBuilder();
    private final StringBuilder table = new StringBuilder();
    private final StringBuilder assignments = new StringBuilder();
    private final StringBuilder where = new StringBuilder();
    private final FromTableVisitor tableVisitor;
    private final AssignmentVisitor assignmentVisitor;
    private final WhereClauseVisitor whereClauseVisitor;

    UpdateStatementVisitor(RenderContext context) {
        this.tableVisitor = new FromTableVisitor(context, it -> {
            if (!this.table.isEmpty()) {
                this.table.append(", ");
            }
            this.table.append(it);
        });
        this.assignmentVisitor = new AssignmentVisitor(context, it -> {
            if (!this.assignments.isEmpty()) {
                this.assignments.append(", ");
            }
            this.assignments.append(it);
        });
        this.whereClauseVisitor = new WhereClauseVisitor(context, this.where::append);
    }

    @Override
    public DelegatingVisitor.Delegation doEnter(Visitable segment) {
        if (segment instanceof Table) {
            return DelegatingVisitor.Delegation.delegateTo(this.tableVisitor);
        }
        if (segment instanceof Assignment) {
            return DelegatingVisitor.Delegation.delegateTo(this.assignmentVisitor);
        }
        if (segment instanceof Where) {
            return DelegatingVisitor.Delegation.delegateTo(this.whereClauseVisitor);
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public DelegatingVisitor.Delegation doLeave(Visitable segment) {
        if (segment instanceof Update) {
            this.builder.append("UPDATE");
            if (!this.table.isEmpty()) {
                this.builder.append(" ").append((CharSequence)this.table);
            }
            if (!this.assignments.isEmpty()) {
                this.builder.append(" SET ").append((CharSequence)this.assignments);
            }
            if (!this.where.isEmpty()) {
                this.builder.append(" WHERE ").append((CharSequence)this.where);
            }
            return DelegatingVisitor.Delegation.leave();
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }
}

