/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;

public class Escaper {
    public static final Escaper DEFAULT = Escaper.of('\\');
    private final char escapeCharacter;
    private final List<String> toReplace;

    private Escaper(char escapeCharacter, List<String> toReplace) {
        if (toReplace.contains(Character.toString(escapeCharacter))) {
            throw new IllegalArgumentException(String.format("'%s' and cannot be used as escape character as it should be replaced", Character.valueOf(escapeCharacter)));
        }
        this.escapeCharacter = escapeCharacter;
        this.toReplace = toReplace;
    }

    public static Escaper of(char escapeCharacter) {
        return new Escaper(escapeCharacter, Arrays.asList("_", "%"));
    }

    public Escaper withRewriteFor(String ... chars) {
        ArrayList<String> toReplace = new ArrayList<String>(this.toReplace.size() + chars.length);
        toReplace.addAll(this.toReplace);
        toReplace.addAll(Arrays.asList(chars));
        return new Escaper(this.escapeCharacter, toReplace);
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public @Nullable String escape(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return this.toReplace.stream().reduce(value, (it, character) -> it.replace((CharSequence)character, this.escapeCharacter + character));
    }
}

