/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Optional;
import java.util.Set;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.DerivedSqlIdentifier;
import org.springframework.data.relational.core.mapping.Embedded;
import org.springframework.data.relational.core.mapping.InsertOnlyProperty;
import org.springframework.data.relational.core.mapping.MappedCollection;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.Sequence;
import org.springframework.data.relational.core.mapping.SqlIdentifierExpressionEvaluator;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicRelationalPersistentProperty
extends AnnotationBasedPersistentProperty<RelationalPersistentProperty>
implements RelationalPersistentProperty {
    private static final ValueExpressionParser PARSER = ValueExpressionParser.create();
    private final Lazy<SqlIdentifier> columnName;
    private final boolean hasExplicitColumnName;
    @Nullable
    private final ValueExpression columnNameExpression;
    private final SqlIdentifier sequence;
    private final Lazy<Optional<SqlIdentifier>> collectionIdColumnName;
    @Nullable
    private final ValueExpression collectionIdColumnNameExpression;
    private final Lazy<SqlIdentifier> collectionKeyColumnName;
    @Nullable
    private final ValueExpression collectionKeyColumnNameExpression;
    private final boolean isEmbedded;
    private final String embeddedPrefix;
    private final NamingStrategy namingStrategy;
    private boolean forceQuote = true;
    private SqlIdentifierExpressionEvaluator sqlIdentifierExpressionEvaluator = new SqlIdentifierExpressionEvaluator(EvaluationContextProvider.DEFAULT);

    public BasicRelationalPersistentProperty(Property property, PersistentEntity<?, RelationalPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, NamingStrategy namingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.namingStrategy = namingStrategy;
        Assert.notNull((Object)namingStrategy, (String)"NamingStrategy must not be null");
        this.isEmbedded = this.isAnnotationPresent(Embedded.class);
        this.embeddedPrefix = Optional.ofNullable((Embedded)this.findAnnotation(Embedded.class)).map(Embedded::prefix).orElse("");
        Lazy collectionIdColumnName = null;
        Lazy collectionKeyColumnName = Lazy.of(() -> this.createDerivedSqlIdentifier(namingStrategy.getKeyColumn(this)));
        if (this.isAnnotationPresent(MappedCollection.class)) {
            MappedCollection mappedCollection = (MappedCollection)this.getRequiredAnnotation(MappedCollection.class);
            if (StringUtils.hasText((String)mappedCollection.idColumn())) {
                collectionIdColumnName = Lazy.of(() -> Optional.of(this.createSqlIdentifier(mappedCollection.idColumn())));
            }
            this.collectionIdColumnNameExpression = BasicRelationalPersistentProperty.detectExpression(mappedCollection.idColumn());
            collectionKeyColumnName = Lazy.of(() -> StringUtils.hasText((String)mappedCollection.keyColumn()) ? this.createSqlIdentifier(mappedCollection.keyColumn()) : this.createDerivedSqlIdentifier(namingStrategy.getKeyColumn(this)));
            this.collectionKeyColumnNameExpression = BasicRelationalPersistentProperty.detectExpression(mappedCollection.keyColumn());
        } else {
            this.collectionIdColumnNameExpression = null;
            this.collectionKeyColumnNameExpression = null;
        }
        if (this.isAnnotationPresent(Column.class)) {
            Column column = (Column)this.getRequiredAnnotation(Column.class);
            this.hasExplicitColumnName = StringUtils.hasText((String)column.value());
            this.columnName = Lazy.of(() -> StringUtils.hasText((String)column.value()) ? this.createSqlIdentifier(column.value()) : this.createDerivedSqlIdentifier(namingStrategy.getColumnName(this)));
            this.columnNameExpression = BasicRelationalPersistentProperty.detectExpression(column.value());
            if (collectionIdColumnName == null && StringUtils.hasText((String)column.value())) {
                collectionIdColumnName = Lazy.of(() -> Optional.of(this.createSqlIdentifier(column.value())));
            }
        } else {
            this.hasExplicitColumnName = false;
            this.columnName = Lazy.of(() -> this.createDerivedSqlIdentifier(namingStrategy.getColumnName(this)));
            this.columnNameExpression = null;
        }
        this.sequence = this.determineSequenceName();
        if (collectionIdColumnName == null) {
            collectionIdColumnName = Lazy.of(Optional.empty());
        }
        this.collectionIdColumnName = collectionIdColumnName;
        this.collectionKeyColumnName = collectionKeyColumnName;
    }

    void setSqlIdentifierExpressionEvaluator(SqlIdentifierExpressionEvaluator sqlIdentifierExpressionEvaluator) {
        this.sqlIdentifierExpressionEvaluator = sqlIdentifierExpressionEvaluator;
    }

    @Nullable
    private static ValueExpression detectExpression(@Nullable String potentialExpression) {
        if (!StringUtils.hasText((String)potentialExpression)) {
            return null;
        }
        ValueExpression expression = PARSER.parse(potentialExpression);
        return expression.isLiteral() ? null : expression;
    }

    private SqlIdentifier createSqlIdentifier(String name) {
        return this.isForceQuote() ? SqlIdentifier.quoted(name) : SqlIdentifier.unquoted(name);
    }

    private SqlIdentifier createDerivedSqlIdentifier(String name) {
        return new DerivedSqlIdentifier(name, this.isForceQuote());
    }

    protected Association<RelationalPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    public boolean isForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(boolean forceQuote) {
        this.forceQuote = forceQuote;
    }

    public boolean isEntity() {
        return super.isEntity() && !this.isAssociation();
    }

    @Override
    public SqlIdentifier getColumnName() {
        if (this.columnNameExpression == null) {
            return (SqlIdentifier)this.columnName.get();
        }
        return this.sqlIdentifierExpressionEvaluator.evaluate(this.columnNameExpression, this.isForceQuote());
    }

    @Override
    public boolean hasExplicitColumnName() {
        return this.hasExplicitColumnName;
    }

    @Override
    public RelationalPersistentEntity<?> getOwner() {
        return (RelationalPersistentEntity)super.getOwner();
    }

    @Override
    public SqlIdentifier getReverseColumnName(RelationalPersistentEntity<?> owner) {
        if (this.collectionIdColumnNameExpression == null) {
            return ((Optional)this.collectionIdColumnName.get()).orElseGet(() -> this.createDerivedSqlIdentifier(this.namingStrategy.getReverseColumnName(owner)));
        }
        return this.sqlIdentifierExpressionEvaluator.evaluate(this.collectionIdColumnNameExpression, this.isForceQuote());
    }

    @Override
    public SqlIdentifier getKeyColumn() {
        if (!this.isQualified()) {
            return null;
        }
        if (this.collectionKeyColumnNameExpression == null) {
            return (SqlIdentifier)this.collectionKeyColumnName.get();
        }
        return this.sqlIdentifierExpressionEvaluator.evaluate(this.collectionKeyColumnNameExpression, this.isForceQuote());
    }

    @Override
    public boolean isQualified() {
        return this.isMap() || this.isListLike();
    }

    @Override
    public Class<?> getQualifierColumnType() {
        Assert.isTrue((boolean)this.isQualified(), (String)"The qualifier column type is only defined for properties that are qualified");
        if (this.isMap()) {
            return this.getTypeInformation().getRequiredComponentType().getType();
        }
        return Integer.class;
    }

    @Override
    public boolean isOrdered() {
        return this.isListLike();
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded || this.isIdProperty() && this.isEntity();
    }

    @Override
    public String getEmbeddedPrefix() {
        return this.isEmbedded() ? this.embeddedPrefix : null;
    }

    @Override
    public boolean shouldCreateEmptyEmbedded() {
        Embedded findAnnotation = (Embedded)this.findAnnotation(Embedded.class);
        return findAnnotation != null && Embedded.OnEmpty.USE_EMPTY.equals((Object)findAnnotation.onEmpty()) || this.isIdProperty() && this.isEntity();
    }

    @Override
    public boolean isInsertOnly() {
        return this.findAnnotation(InsertOnlyProperty.class) != null;
    }

    @Override
    @Nullable
    public SqlIdentifier getSequence() {
        return this.sequence;
    }

    private boolean isListLike() {
        return this.isCollectionLike() && !Set.class.isAssignableFrom(this.getType());
    }

    @Nullable
    private SqlIdentifier determineSequenceName() {
        if (this.isAnnotationPresent(Sequence.class)) {
            Sequence annotation = (Sequence)this.getRequiredAnnotation(Sequence.class);
            String sequence = annotation.sequence();
            String schema = annotation.schema();
            SqlIdentifier sequenceIdentifier = SqlIdentifier.quoted(sequence);
            if (StringUtils.hasText((String)schema)) {
                sequenceIdentifier = SqlIdentifier.from(SqlIdentifier.quoted(schema), sequenceIdentifier);
            }
            return sequenceIdentifier;
        }
        return null;
    }
}

