/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.Into;
import org.springframework.data.relational.core.sql.Values;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.ColumnVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.IntoClauseVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.ValuesVisitor;
import org.springframework.util.Assert;

class InsertStatementVisitor
extends DelegatingVisitor
implements PartRenderer {
    private final StringBuilder builder = new StringBuilder();
    private final StringBuilder into = new StringBuilder();
    private final StringBuilder columns = new StringBuilder();
    private final StringBuilder values = new StringBuilder();
    private final IntoClauseVisitor intoClauseVisitor;
    private final ColumnVisitor columnVisitor;
    private final ValuesVisitor valuesVisitor;
    private final RenderContext renderContext;

    InsertStatementVisitor(RenderContext renderContext) {
        Assert.notNull((Object)renderContext, (String)"renderContext must not be null");
        this.renderContext = renderContext;
        this.intoClauseVisitor = this.createIntoClauseVisitor(renderContext);
        this.columnVisitor = this.createColumnVisitor(renderContext);
        this.valuesVisitor = new ValuesVisitor(renderContext, this.values::append);
    }

    @Override
    public DelegatingVisitor.Delegation doEnter(Visitable segment) {
        if (segment instanceof Into) {
            return DelegatingVisitor.Delegation.delegateTo(this.intoClauseVisitor);
        }
        if (segment instanceof Column) {
            return DelegatingVisitor.Delegation.delegateTo(this.columnVisitor);
        }
        if (segment instanceof Values) {
            return DelegatingVisitor.Delegation.delegateTo(this.valuesVisitor);
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public DelegatingVisitor.Delegation doLeave(Visitable segment) {
        if (segment instanceof Insert) {
            this.builder.append("INSERT");
            this.builder.append(" INTO ").append((CharSequence)this.into);
            this.addInsertColumnsIfPresent();
            this.addInsertValuesIfPresentElseDefault();
            return DelegatingVisitor.Delegation.leave();
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }

    private void addInsertValuesIfPresentElseDefault() {
        if (this.values.length() != 0) {
            this.builder.append(" VALUES (").append((CharSequence)this.values).append(")");
        } else {
            this.addInsertWithDefaultValuesToBuilder();
        }
    }

    private void addInsertColumnsIfPresent() {
        if (this.columns.length() != 0) {
            this.builder.append(" (").append((CharSequence)this.columns).append(")");
        }
    }

    private void addInsertWithDefaultValuesToBuilder() {
        this.builder.append(this.renderContext.getInsertRenderContext().getDefaultValuesInsertPart());
    }

    private ColumnVisitor createColumnVisitor(RenderContext context) {
        return new ColumnVisitor(context, false, it -> {
            if (this.columns.length() != 0) {
                this.columns.append(", ");
            }
            this.columns.append(it);
        });
    }

    private IntoClauseVisitor createIntoClauseVisitor(RenderContext context) {
        return new IntoClauseVisitor(context, it -> {
            if (this.into.length() != 0) {
                this.into.append(", ");
            }
            this.into.append(it);
        });
    }
}

