/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.AggregatePathTraversal;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultAggregatePath
implements AggregatePath {
    private final RelationalMappingContext context;
    @Nullable
    private final RelationalPersistentEntity<?> rootType;
    @Nullable
    private final PersistentPropertyPath<RelationalPersistentProperty> path;
    private final Lazy<AggregatePath.TableInfo> tableInfo = Lazy.of(() -> AggregatePath.TableInfo.of(this));
    private final Lazy<AggregatePath.ColumnInfo> columnInfo = Lazy.of(() -> AggregatePath.ColumnInfo.of(this));

    DefaultAggregatePath(RelationalMappingContext context, PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
        Assert.notNull((Object)((Object)context), (String)"context must not be null");
        Assert.notNull(path, (String)"path must not be null");
        this.context = context;
        this.path = path;
        this.rootType = ((RelationalPersistentProperty)path.getBaseProperty()).getOwner();
    }

    DefaultAggregatePath(RelationalMappingContext context, RelationalPersistentEntity<?> rootType) {
        Assert.notNull((Object)((Object)context), (String)"context must not be null");
        Assert.notNull(rootType, (String)"rootType must not be null");
        this.context = context;
        this.rootType = rootType;
        this.path = null;
    }

    @Override
    public AggregatePath getParentPath() {
        if (this.isRoot()) {
            throw new IllegalStateException("The parent path of a root path is not defined.");
        }
        PersistentPropertyPath<RelationalPersistentProperty> path = this.getRequiredPersistentPropertyPath();
        if (path.getLength() == 1) {
            return this.context.getAggregatePath(((RelationalPersistentProperty)path.getLeafProperty()).getOwner());
        }
        return this.context.getAggregatePath((PersistentPropertyPath<? extends RelationalPersistentProperty>)path.getParentPath());
    }

    @Override
    public AggregatePath append(RelationalPersistentProperty property) {
        PersistentPropertyPath newPath = this.isRoot() ? this.context.getPersistentPropertyPath(property.getName(), this.rootType.getType()) : this.context.getPersistentPropertyPath(this.path.toDotPath() + "." + property.getName(), ((RelationalPersistentProperty)this.path.getBaseProperty()).getOwner().getType());
        return this.context.getAggregatePath((PersistentPropertyPath<? extends RelationalPersistentProperty>)newPath);
    }

    @Override
    public boolean isRoot() {
        return this.path == null;
    }

    @Override
    public boolean isWritable() {
        return this.stream().allMatch(path -> path.isRoot() || path.getRequiredLeafProperty().isWritable());
    }

    @Override
    public boolean isEntity() {
        return this.isRoot() || this.getRequiredLeafProperty().isEntity();
    }

    @Override
    public boolean isEmbedded() {
        return !this.isRoot() && this.getRequiredLeafProperty().isEmbedded();
    }

    @Override
    public boolean isMultiValued() {
        return !this.isRoot() && (this.getRequiredLeafProperty().isCollectionLike() || this.getRequiredLeafProperty().isQualified() || this.getParentPath().isMultiValued());
    }

    @Override
    public boolean isQualified() {
        return !this.isRoot() && this.getRequiredLeafProperty().isQualified();
    }

    @Override
    public boolean isMap() {
        return !this.isRoot() && this.getRequiredLeafProperty().isMap();
    }

    @Override
    public boolean isCollectionLike() {
        return !this.isRoot() && this.getRequiredLeafProperty().isCollectionLike();
    }

    @Override
    public boolean isOrdered() {
        return !this.isRoot() && this.getRequiredLeafProperty().isOrdered();
    }

    @Override
    public boolean hasIdProperty() {
        RelationalPersistentEntity<?> leafEntity = this.getLeafEntity();
        return leafEntity != null && leafEntity.hasIdProperty();
    }

    @Override
    public RelationalPersistentProperty getRequiredIdProperty() {
        return this.isRoot() ? (RelationalPersistentProperty)this.rootType.getRequiredIdProperty() : (RelationalPersistentProperty)this.getRequiredLeafEntity().getRequiredIdProperty();
    }

    @Override
    public PersistentPropertyPath<RelationalPersistentProperty> getRequiredPersistentPropertyPath() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Root Aggregate Paths are not associated with a PersistentPropertyPath");
        return this.path;
    }

    @Override
    public RelationalPersistentEntity<?> getLeafEntity() {
        return this.isRoot() ? this.rootType : (RelationalPersistentEntity)this.context.getPersistentEntity(this.getRequiredLeafProperty().getActualType());
    }

    @Override
    public String toDotPath() {
        return this.isRoot() ? "" : this.getRequiredPersistentPropertyPath().toDotPath();
    }

    @Override
    public AggregatePath getIdDefiningParentPath() {
        return AggregatePathTraversal.getIdDefiningPath(this);
    }

    private AggregatePath getTableOwningAncestor() {
        return AggregatePathTraversal.getTableOwningPath(this);
    }

    @Override
    public Iterator<AggregatePath> iterator() {
        return new AggregatePathIterator(this);
    }

    @Override
    public AggregatePath.TableInfo getTableInfo() {
        return (AggregatePath.TableInfo)this.tableInfo.get();
    }

    @Override
    public AggregatePath.ColumnInfo getColumnInfo() {
        return (AggregatePath.ColumnInfo)this.columnInfo.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAggregatePath that = (DefaultAggregatePath)o;
        return Objects.equals((Object)this.context, (Object)that.context) && Objects.equals(this.rootType, that.rootType) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.context, this.rootType, this.path});
    }

    public String toString() {
        return "AggregatePath[" + (this.rootType == null ? ((RelationalPersistentProperty)this.path.getBaseProperty()).getOwner().getType().getName() : this.rootType.getName()) + "]" + (this.isRoot() ? "/" : this.path.toDotPath());
    }

    private static class AggregatePathIterator
    implements Iterator<AggregatePath> {
        @Nullable
        private AggregatePath current;

        public AggregatePathIterator(AggregatePath current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public AggregatePath next() {
            AggregatePath element = this.current;
            if (element == null) {
                throw new NoSuchElementException();
            }
            this.current = element.isRoot() ? null : element.getParentPath();
            return element;
        }
    }
}

