/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SelectList;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.ExpressionVisitor;
import org.springframework.data.relational.core.sql.render.NameRenderer;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;

class SelectListVisitor
extends TypedSubtreeVisitor<SelectList>
implements PartRenderer {
    private final RenderContext context;
    private final StringBuilder builder = new StringBuilder();
    private final RenderTarget target;
    private boolean requiresComma = false;
    private ExpressionVisitor expressionVisitor;

    SelectListVisitor(RenderContext context, RenderTarget target) {
        this.context = context;
        this.target = target;
        this.expressionVisitor = new ExpressionVisitor(context, ExpressionVisitor.AliasHandling.IGNORE);
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (this.requiresComma) {
            this.builder.append(", ");
            this.requiresComma = false;
        }
        if (segment instanceof Expression) {
            return DelegatingVisitor.Delegation.delegateTo(this.expressionVisitor);
        }
        return super.enterNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(SelectList segment) {
        this.target.onRendered(this.builder);
        return super.leaveMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (segment instanceof Expression) {
            this.builder.append(this.expressionVisitor.getRenderedPart());
            this.requiresComma = true;
        }
        if (segment instanceof Aliased) {
            this.builder.append(" AS ").append(NameRenderer.render(this.context, (Aliased)((Object)segment)));
        }
        return super.leaveNested(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }
}

