/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import java.util.Locale;
import java.util.function.Function;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.RenderNamingStrategy;
import org.springframework.util.Assert;

public abstract class NamingStrategies {
    private NamingStrategies() {
    }

    public static RenderNamingStrategy asIs() {
        return AsIs.INSTANCE;
    }

    public static RenderNamingStrategy mapWith(Function<String, String> mappingFunction) {
        return AsIs.INSTANCE.map(mappingFunction);
    }

    public static RenderNamingStrategy toUpper() {
        return NamingStrategies.toUpper(Locale.getDefault());
    }

    public static RenderNamingStrategy toUpper(Locale locale) {
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        return AsIs.INSTANCE.map(it -> it.toUpperCase(locale));
    }

    public static RenderNamingStrategy toLower() {
        return NamingStrategies.toLower(Locale.getDefault());
    }

    public static RenderNamingStrategy toLower(Locale locale) {
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        return AsIs.INSTANCE.map(it -> it.toLowerCase(locale));
    }

    static enum AsIs implements RenderNamingStrategy
    {
        INSTANCE;

    }

    static class DelegatingRenderNamingStrategy
    implements RenderNamingStrategy {
        private final RenderNamingStrategy delegate;
        private final Function<String, String> mappingFunction;

        DelegatingRenderNamingStrategy(RenderNamingStrategy delegate, Function<String, String> mappingFunction) {
            this.delegate = delegate;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public SqlIdentifier getName(Column column) {
            return this.delegate.getName(column).transform(this.mappingFunction::apply);
        }

        @Override
        public SqlIdentifier getReferenceName(Column column) {
            return this.delegate.getReferenceName(column).transform(this.mappingFunction::apply);
        }

        @Override
        public SqlIdentifier getName(TableLike table) {
            return this.delegate.getName(table).transform(this.mappingFunction::apply);
        }

        @Override
        public SqlIdentifier getReferenceName(TableLike table) {
            return this.delegate.getReferenceName(table).transform(this.mappingFunction::apply);
        }
    }
}

