/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.relational.core.sql.AsteriskFromTable;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;

public interface TableLike
extends Segment {
    default public Column column(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        return new Column(name, this);
    }

    default public Column column(SqlIdentifier name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return new Column(name, this);
    }

    default public List<Column> columns(String ... names) {
        Assert.notNull((Object)names, (String)"Names must not be null");
        return this.columns(Arrays.asList(names));
    }

    default public List<Column> columns(SqlIdentifier ... names) {
        Assert.notNull((Object)names, (String)"Names must not be null");
        ArrayList<Column> columns = new ArrayList<Column>();
        for (SqlIdentifier name : names) {
            columns.add(this.column(name));
        }
        return columns;
    }

    default public List<Column> columns(Collection<String> names) {
        Assert.notNull(names, (String)"Names must not be null");
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String name : names) {
            columns.add(this.column(name));
        }
        return columns;
    }

    default public AsteriskFromTable asterisk() {
        return new AsteriskFromTable(this);
    }

    public SqlIdentifier getName();

    public SqlIdentifier getReferenceName();
}

