/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PersistentPropertyPaths;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.MutableAggregateChange;
import org.springframework.data.relational.core.conversion.PathNode;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class WritingContext {
    private final RelationalMappingContext context;
    private final Object root;
    private final Object entity;
    private final Class<?> entityType;
    private final PersistentPropertyPaths<?, RelationalPersistentProperty> paths;
    private final Map<PathNode, DbAction<?>> previousActions = new HashMap();
    private final Map<PersistentPropertyPath<RelationalPersistentProperty>, List<PathNode>> nodesCache = new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, List<PathNode>>();

    WritingContext(RelationalMappingContext context, Object root, MutableAggregateChange<?> aggregateChange) {
        this.context = context;
        this.root = root;
        this.entity = aggregateChange.getEntity();
        this.entityType = aggregateChange.getEntityType();
        this.paths = context.findPersistentPropertyPaths(this.entityType, p -> p.isEntity() && !p.isEmbedded());
    }

    List<DbAction<?>> insert() {
        ArrayList actions = new ArrayList();
        actions.add(this.setRootAction(new DbAction.InsertRoot<Object>(this.entity)));
        actions.addAll(this.insertReferenced());
        return actions;
    }

    List<DbAction<?>> update() {
        ArrayList actions = new ArrayList();
        actions.add(this.setRootAction(new DbAction.UpdateRoot<Object>(this.entity)));
        actions.addAll(this.deleteReferenced());
        actions.addAll(this.insertReferenced());
        return actions;
    }

    List<DbAction<?>> save() {
        ArrayList actions = new ArrayList();
        if (this.isNew(this.root)) {
            actions.add(this.setRootAction(new DbAction.InsertRoot<Object>(this.entity)));
            actions.addAll(this.insertReferenced());
        } else {
            actions.add(this.setRootAction(new DbAction.UpdateRoot<Object>(this.entity)));
            actions.addAll(this.deleteReferenced());
            actions.addAll(this.insertReferenced());
        }
        return actions;
    }

    private boolean isNew(Object o) {
        return ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(o.getClass())).isNew(o);
    }

    private List<DbAction<?>> insertReferenced() {
        ArrayList actions = new ArrayList();
        this.paths.forEach(path -> actions.addAll(this.insertAll((PersistentPropertyPath<RelationalPersistentProperty>)path)));
        return actions;
    }

    private List<DbAction<?>> insertAll(PersistentPropertyPath<RelationalPersistentProperty> path) {
        ArrayList actions = new ArrayList();
        this.from(path).forEach(node -> {
            DbAction.Insert<Object> insert;
            DbAction.WithEntity<?> parentAction = this.getAction(node.getParent());
            if (((RelationalPersistentProperty)node.getPath().getRequiredLeafProperty()).isQualified()) {
                Pair value = (Pair)node.getValue();
                HashMap<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers = new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, Object>();
                qualifiers.put(node.getPath(), value.getFirst());
                RelationalPersistentEntity parentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(parentAction.getEntityType());
                if (!parentEntity.hasIdProperty() && parentAction instanceof DbAction.Insert) {
                    qualifiers.putAll(((DbAction.Insert)parentAction).getQualifiers());
                }
                insert = new DbAction.Insert<Object>(value.getSecond(), path, parentAction, qualifiers);
            } else {
                insert = new DbAction.Insert<Object>(node.getValue(), path, parentAction, new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, Object>());
            }
            this.previousActions.put((PathNode)node, (DbAction<?>)insert);
            actions.add(insert);
        });
        return actions;
    }

    private List<DbAction<?>> deleteReferenced() {
        ArrayList deletes = new ArrayList();
        this.paths.forEach(path -> deletes.add(0, this.deleteReferenced((PersistentPropertyPath<RelationalPersistentProperty>)path)));
        return deletes;
    }

    private DbAction.Delete<?> deleteReferenced(PersistentPropertyPath<RelationalPersistentProperty> path) {
        Object id = ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(this.entityType)).getIdentifierAccessor(this.entity).getIdentifier();
        return new DbAction.Delete(id, path);
    }

    private DbAction<?> setRootAction(DbAction<?> dbAction) {
        this.previousActions.put(null, dbAction);
        return dbAction;
    }

    @Nullable
    private DbAction.WithEntity<?> getAction(@Nullable PathNode parent) {
        DbAction<?> action = this.previousActions.get(parent);
        if (action != null) {
            Assert.isInstanceOf(DbAction.WithEntity.class, action, (String)("dependsOn action is not a WithEntity, but " + action.getClass().getSimpleName()));
            return (DbAction.WithEntity)action;
        }
        return null;
    }

    private List<PathNode> from(PersistentPropertyPath<RelationalPersistentProperty> path) {
        ArrayList<PathNode> nodes = new ArrayList<PathNode>();
        if (this.isDirectlyReferencedByRootIgnoringEmbeddables(path)) {
            Object value = this.getFromRootValue(path);
            nodes.addAll(this.createNodes(path, null, value));
        } else {
            List<PathNode> pathNodes = this.nodesCache.getOrDefault(path.getParentPath(), Collections.emptyList());
            pathNodes.forEach(parentNode -> {
                Object parentValue = parentNode.getActualValue();
                Object value = ((RelationalPersistentProperty)path.getRequiredLeafProperty()).getOwner().getPropertyAccessor(parentValue).getProperty(path.getRequiredLeafProperty());
                nodes.addAll(this.createNodes(path, (PathNode)parentNode, value));
            });
        }
        this.nodesCache.put(path, nodes);
        return nodes;
    }

    private boolean isDirectlyReferencedByRootIgnoringEmbeddables(PersistentPropertyPath<RelationalPersistentProperty> path) {
        PersistentPropertyPath currentPath = path.getParentPath();
        while (!currentPath.isEmpty()) {
            if (!((RelationalPersistentProperty)currentPath.getRequiredLeafProperty()).isEmbedded()) {
                return false;
            }
            currentPath = currentPath.getParentPath();
        }
        return true;
    }

    @Nullable
    private Object getFromRootValue(PersistentPropertyPath<RelationalPersistentProperty> path) {
        if (path.getLength() == 0) {
            return this.entity;
        }
        Object parent = this.getFromRootValue((PersistentPropertyPath<RelationalPersistentProperty>)path.getParentPath());
        if (parent == null) {
            return null;
        }
        return ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(parent.getClass())).getPropertyAccessor(parent).getProperty(path.getRequiredLeafProperty());
    }

    private List<PathNode> createNodes(PersistentPropertyPath<RelationalPersistentProperty> path, @Nullable PathNode parentNode, @Nullable Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<PathNode> nodes = new ArrayList<PathNode>();
        if (((RelationalPersistentProperty)path.getRequiredLeafProperty()).isEmbedded()) {
            nodes.add(new PathNode(path, parentNode, value));
        } else if (((RelationalPersistentProperty)path.getRequiredLeafProperty()).isQualified()) {
            if (((RelationalPersistentProperty)path.getRequiredLeafProperty()).isMap()) {
                ((Map)value).forEach((k, v) -> nodes.add(new PathNode(path, parentNode, Pair.of((Object)k, (Object)v))));
            } else {
                List listValue = (List)value;
                for (int k2 = 0; k2 < listValue.size(); ++k2) {
                    nodes.add(new PathNode(path, parentNode, Pair.of((Object)k2, listValue.get(k2))));
                }
            }
        } else if (((RelationalPersistentProperty)path.getRequiredLeafProperty()).isCollectionLike()) {
            if (value.getClass().isArray()) {
                Arrays.asList((Object[])value).forEach(v -> nodes.add(new PathNode(path, parentNode, v)));
            } else {
                ((Iterable)value).forEach(v -> nodes.add(new PathNode(path, parentNode, v)));
            }
        } else {
            nodes.add(new PathNode(path, parentNode, value));
        }
        return nodes;
    }
}

