/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Query {
    @Nullable
    private final CriteriaDefinition criteria;
    private final List<SqlIdentifier> columns;
    private final Sort sort;
    private final int limit;
    private final long offset;

    public static Query query(CriteriaDefinition criteria) {
        return new Query(criteria);
    }

    private Query(@Nullable CriteriaDefinition criteria) {
        this(criteria, Collections.emptyList(), Sort.unsorted(), -1, -1L);
    }

    private Query(@Nullable CriteriaDefinition criteria, List<SqlIdentifier> columns, Sort sort, int limit, long offset) {
        this.criteria = criteria;
        this.columns = columns;
        this.sort = sort;
        this.limit = limit;
        this.offset = offset;
    }

    public static Query empty() {
        return new Query(null);
    }

    public Query columns(String ... columns) {
        Assert.notNull((Object)columns, (String)"Columns must not be null");
        return this.withColumns(Arrays.stream(columns).map(SqlIdentifier::unquoted).collect(Collectors.toList()));
    }

    public Query columns(Collection<String> columns) {
        Assert.notNull(columns, (String)"Columns must not be null");
        return this.withColumns(columns.stream().map(SqlIdentifier::unquoted).collect(Collectors.toList()));
    }

    public Query columns(SqlIdentifier ... columns) {
        Assert.notNull((Object)columns, (String)"Columns must not be null");
        return this.withColumns(Arrays.asList(columns));
    }

    private Query withColumns(Collection<SqlIdentifier> columns) {
        Assert.notNull(columns, (String)"Columns must not be null");
        ArrayList<SqlIdentifier> newColumns = new ArrayList<SqlIdentifier>(this.columns);
        newColumns.addAll(columns);
        return new Query(this.criteria, newColumns, this.sort, this.limit, this.offset);
    }

    public Query offset(long offset) {
        return new Query(this.criteria, this.columns, this.sort, this.limit, offset);
    }

    public Query limit(int limit) {
        return new Query(this.criteria, this.columns, this.sort, limit, this.offset);
    }

    public Query with(Pageable pageable) {
        if (pageable.isUnpaged()) {
            return this;
        }
        Query.assertNoCaseSort(pageable.getSort());
        return new Query(this.criteria, this.columns, this.sort.and(pageable.getSort()), pageable.getPageSize(), pageable.getOffset());
    }

    public Query sort(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        if (sort.isUnsorted()) {
            return this;
        }
        Query.assertNoCaseSort(sort);
        return new Query(this.criteria, this.columns, this.sort.and(sort), this.limit, this.offset);
    }

    public Optional<CriteriaDefinition> getCriteria() {
        return Optional.ofNullable(this.criteria);
    }

    public List<SqlIdentifier> getColumns() {
        return this.columns;
    }

    public boolean isSorted() {
        return this.sort.isSorted();
    }

    public Sort getSort() {
        return this.sort;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    private static void assertNoCaseSort(Sort sort) {
        for (Sort.Order order : sort) {
            if (!order.isIgnoreCase()) continue;
            throw new IllegalArgumentException(String.format("Given sort contained an Order for %s with ignore case;Ignore case sorting is not supported", order.getProperty()));
        }
    }
}

