/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.BasicRelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.CachingNamingStrategy;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntityImpl;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class RelationalMappingContext
extends AbstractMappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> {
    private final NamingStrategy namingStrategy;
    private boolean forceQuote = true;

    public RelationalMappingContext() {
        this(NamingStrategy.INSTANCE);
    }

    public RelationalMappingContext(NamingStrategy namingStrategy) {
        Assert.notNull((Object)namingStrategy, (String)"NamingStrategy must not be null!");
        this.namingStrategy = new CachingNamingStrategy(namingStrategy);
        this.setSimpleTypeHolder(SimpleTypeHolder.DEFAULT);
    }

    public boolean isForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(boolean forceQuote) {
        this.forceQuote = forceQuote;
    }

    protected <T> RelationalPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        RelationalPersistentEntityImpl<T> entity = new RelationalPersistentEntityImpl<T>(typeInformation, this.namingStrategy);
        entity.setForceQuote(this.isForceQuote());
        return entity;
    }

    protected RelationalPersistentProperty createPersistentProperty(Property property, RelationalPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        BasicRelationalPersistentProperty persistentProperty = new BasicRelationalPersistentProperty(property, (PersistentEntity<?, RelationalPersistentProperty>)owner, simpleTypeHolder, this.namingStrategy);
        persistentProperty.setForceQuote(this.isForceQuote());
        return persistentProperty;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }
}

