/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.util.Assert;

public interface RedisScript<T> {
    public String getSha1();

    public @Nullable Class<T> getResultType();

    public String getScriptAsString();

    default public boolean returnsRawValue() {
        return this.getResultType() == null;
    }

    public static <T> RedisScript<T> of(String script) {
        return new DefaultRedisScript(script);
    }

    public static <T> RedisScript<T> of(String script, Class<T> resultType) {
        Assert.notNull((Object)script, (String)"Script must not be null");
        Assert.notNull(resultType, (String)"ResultType must not be null");
        return new DefaultRedisScript<T>(script, resultType);
    }

    public static <T> RedisScript<T> of(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        DefaultRedisScript script = new DefaultRedisScript();
        script.setLocation(resource);
        return script;
    }

    public static <T> RedisScript<T> of(Resource resource, Class<T> resultType) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        Assert.notNull(resultType, (String)"ResultType must not be null");
        DefaultRedisScript<T> script = new DefaultRedisScript<T>();
        script.setResultType(resultType);
        script.setLocation(resource);
        return script;
    }
}

