/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.convert.BinaryConverters;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.util.Assert;

public class ReferenceResolverImpl
implements ReferenceResolver {
    private final RedisOperations<?, ?> redisOps;
    private final BinaryConverters.StringToBytesConverter converter;

    public ReferenceResolverImpl(RedisOperations<?, ?> redisOperations) {
        Assert.notNull(redisOperations, (String)"RedisOperations must not be null");
        this.redisOps = redisOperations;
        this.converter = new BinaryConverters.StringToBytesConverter();
    }

    @Override
    public @Nullable Map<byte[], byte[]> resolveReference(Object id, String keyspace) {
        byte[] key = this.converter.convert(keyspace + ":" + String.valueOf(id));
        return this.redisOps.execute(connection -> connection.hGetAll(key));
    }
}

