/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundKeyExpirationOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundStreamOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultBoundKeyExpirationOperations;
import org.springframework.data.redis.core.ExpireChanges;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

@NullUnmarked
public interface RedisOperations<K, V> {
    public <T> T execute(@NonNull RedisCallback<T> var1);

    public <T> T execute(@NonNull SessionCallback<T> var1);

    public @NonNull List<Object> executePipelined(@NonNull RedisCallback<?> var1);

    public @NonNull List<Object> executePipelined(@NonNull RedisCallback<?> var1, @NonNull RedisSerializer<?> var2);

    public @NonNull List<Object> executePipelined(@NonNull SessionCallback<?> var1);

    public @NonNull List<Object> executePipelined(@NonNull SessionCallback<?> var1, @NonNull RedisSerializer<?> var2);

    public <T> T execute(@NonNull RedisScript<T> var1, @NonNull List<@NonNull K> var2, Object ... var3);

    public <T> T execute(@NonNull RedisScript<T> var1, @NonNull RedisSerializer<?> var2, @NonNull RedisSerializer<T> var3, @NonNull List<@NonNull K> var4, Object ... var5);

    public <T extends Closeable> T executeWithStickyConnection(@NonNull RedisCallback<T> var1);

    public Boolean copy(@NonNull K var1, @NonNull K var2, boolean var3);

    public Boolean hasKey(@NonNull K var1);

    public Long countExistingKeys(@NonNull Collection<@NonNull K> var1);

    public Boolean delete(@NonNull K var1);

    public Long delete(@NonNull Collection<@NonNull K> var1);

    public Boolean unlink(@NonNull K var1);

    public Long unlink(@NonNull Collection<@NonNull K> var1);

    public DataType type(@NonNull K var1);

    public Set<@NonNull K> keys(@NonNull K var1);

    public @NonNull Cursor<@NonNull K> scan(@NonNull ScanOptions var1);

    public K randomKey();

    public void rename(@NonNull K var1, @NonNull K var2);

    public Boolean renameIfAbsent(@NonNull K var1, @NonNull K var2);

    public Boolean expire(@NonNull K var1, long var2, @NonNull TimeUnit var4);

    default public Boolean expire(@NonNull K key, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        return TimeoutUtils.hasMillis(timeout) ? this.expire(key, timeout.toMillis(), TimeUnit.MILLISECONDS) : this.expire(key, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    public Boolean expireAt(@NonNull K var1, @NonNull Date var2);

    default public Boolean expireAt(@NonNull K key, @NonNull Instant expireAt) {
        Assert.notNull((Object)expireAt, (String)"Timestamp must not be null");
        return this.expireAt(key, Date.from(expireAt));
    }

    public ExpireChanges.ExpiryChangeState expire(@NonNull K var1, @NonNull Expiration var2, @NonNull ExpirationOptions var3);

    default public @NonNull BoundKeyExpirationOperations expiration(@NonNull K key) {
        return new DefaultBoundKeyExpirationOperations<K>(this, key);
    }

    public Boolean persist(@NonNull K var1);

    public Long getExpire(@NonNull K var1);

    public Long getExpire(@NonNull K var1, @NonNull TimeUnit var2);

    public Boolean move(@NonNull K var1, int var2);

    public byte[] dump(@NonNull K var1);

    default public void restore(@NonNull K key, byte @NonNull [] value, long timeToLive, @NonNull TimeUnit unit) {
        this.restore(key, value, timeToLive, unit, false);
    }

    public void restore(@NonNull K var1, byte @NonNull [] var2, long var3, @NonNull TimeUnit var5, boolean var6);

    public List<V> sort(@NonNull SortQuery<@NonNull K> var1);

    public <T> List<T> sort(@NonNull SortQuery<@NonNull K> var1, @NonNull RedisSerializer<T> var2);

    public <T> List<T> sort(@NonNull SortQuery<@NonNull K> var1, @NonNull BulkMapper<T, V> var2);

    public <T, S> List<T> sort(SortQuery<@NonNull K> var1, @NonNull BulkMapper<T, S> var2, @NonNull RedisSerializer<S> var3);

    public Long sort(@NonNull SortQuery<@NonNull K> var1, @NonNull K var2);

    public void watch(@NonNull K var1);

    public void watch(@NonNull Collection<@NonNull K> var1);

    public void unwatch();

    public void multi();

    public void discard();

    public @NonNull List<Object> exec();

    public @NonNull List<Object> exec(@NonNull RedisSerializer<?> var1);

    public List<@NonNull RedisClientInfo> getClientList();

    public void killClient(@NonNull String var1, int var2);

    public void replicaOf(@NonNull String var1, int var2);

    public void replicaOfNoOne();

    public Long convertAndSend(@NonNull String var1, @NonNull Object var2);

    public @NonNull ClusterOperations<K, V> opsForCluster();

    public @NonNull GeoOperations<K, V> opsForGeo();

    public @NonNull BoundGeoOperations<K, V> boundGeoOps(@NonNull K var1);

    public <HK, HV> @NonNull HashOperations<K, HK, HV> opsForHash();

    public <HK, HV> @NonNull BoundHashOperations<K, HK, HV> boundHashOps(@NonNull K var1);

    public @NonNull HyperLogLogOperations<K, V> opsForHyperLogLog();

    public @NonNull ListOperations<K, V> opsForList();

    public @NonNull BoundListOperations<K, V> boundListOps(K var1);

    public @NonNull SetOperations<K, V> opsForSet();

    public @NonNull BoundSetOperations<K, V> boundSetOps(@NonNull K var1);

    public <HK, HV> @NonNull StreamOperations<K, HK, HV> opsForStream();

    public <HK, HV> @NonNull StreamOperations<K, HK, HV> opsForStream(@NonNull HashMapper<? super K, ? super HK, ? super HV> var1);

    public <HK, HV> @NonNull BoundStreamOperations<K, HK, HV> boundStreamOps(@NonNull K var1);

    public @NonNull ValueOperations<K, V> opsForValue();

    public @NonNull BoundValueOperations<K, V> boundValueOps(@NonNull K var1);

    public @NonNull ZSetOperations<K, V> opsForZSet();

    public @NonNull BoundZSetOperations<K, V> boundZSetOps(@NonNull K var1);

    public @Nullable RedisSerializer<?> getKeySerializer();

    public @Nullable RedisSerializer<?> getValueSerializer();

    public @Nullable RedisSerializer<?> getHashKeySerializer();

    public @Nullable RedisSerializer<?> getHashValueSerializer();
}

