/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.stream.ByteBufferRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.HashMapperProvider;
import org.springframework.data.redis.core.StreamObjectMapper;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@NullUnmarked
public interface ReactiveStreamOperations<K, HK, HV>
extends HashMapperProvider<HK, HV> {
    default public Mono<Long> acknowledge(@NonNull K key, @NonNull String group, String ... recordIds) {
        return this.acknowledge(key, group, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    public Mono<Long> acknowledge(@NonNull K var1, @NonNull String var2, RecordId ... var3);

    default public Mono<Long> acknowledge(@NonNull String group, @NonNull Record<K, ?> record) {
        return this.acknowledge(record.getRequiredStream(), group, record.getId());
    }

    default public Mono<RecordId> add(@NonNull K key, @NonNull Map<? extends HK, ? extends HV> content,  @NonNull RedisStreamCommands.XAddOptions xAddOptions) {
        return this.add(StreamRecords.newRecord().in(key).ofMap(content), xAddOptions);
    }

    default public Mono<RecordId> add(@NonNull MapRecord<K, ? extends HK, ? extends HV> record,  @NonNull RedisStreamCommands.XAddOptions xAddOptions) {
        return this.add((Record<K, ?>)record, xAddOptions);
    }

    public Mono<RecordId> add(@NonNull Record<K, ?> var1,  @NonNull RedisStreamCommands.XAddOptions var2);

    default public Flux<RecordId> add(@NonNull K key, @NonNull Publisher<? extends Map<? extends HK, ? extends HV>> bodyPublisher) {
        return Flux.from(bodyPublisher).flatMap(it -> this.add(key, (Map<? extends HK, ? extends HV>)it));
    }

    default public Mono<RecordId> add(@NonNull K key, @NonNull Map<? extends HK, ? extends HV> content) {
        return this.add(StreamRecords.newRecord().in(key).ofMap(content));
    }

    default public Mono<RecordId> add(@NonNull MapRecord<K, ? extends HK, ? extends HV> record) {
        return this.add((Record<K, ?>)record);
    }

    public Mono<RecordId> add(@NonNull Record<K, ?> var1);

    default public Flux<MapRecord<K, HK, HV>> claim(@NonNull K key, @NonNull String consumerGroup, @NonNull String newOwner, @NonNull Duration minIdleTime, RecordId ... recordIds) {
        return this.claim(key, consumerGroup, newOwner, RedisStreamCommands.XClaimOptions.minIdle(minIdleTime).ids(recordIds));
    }

    public Flux<MapRecord<K, HK, HV>> claim(@NonNull K var1, @NonNull String var2, @NonNull String var3,  @NonNull RedisStreamCommands.XClaimOptions var4);

    default public Mono<Long> delete(@NonNull K key, String ... recordIds) {
        return this.delete(key, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    default public Mono<Long> delete(@NonNull Record<K, ?> record) {
        Assert.notNull(record.getStream(), (String)"Record.getStream() must not be null");
        return this.delete(record.getStream(), record.getId());
    }

    public Mono<Long> delete(@NonNull K var1, RecordId ... var2);

    default public Mono<String> createGroup(@NonNull K key, @NonNull String group) {
        return this.createGroup(key, ReadOffset.latest(), group);
    }

    public Mono<String> createGroup(@NonNull K var1, @NonNull ReadOffset var2, @NonNull String var3);

    public Mono<String> deleteConsumer(@NonNull K var1, @NonNull Consumer var2);

    public Mono<String> destroyGroup(@NonNull K var1, @NonNull String var2);

    public Flux<StreamInfo.XInfoConsumer> consumers(@NonNull K var1, @NonNull String var2);

    public Flux<StreamInfo.XInfoGroup> groups(@NonNull K var1);

    public Mono<StreamInfo.XInfoStream> info(@NonNull K var1);

    public Mono<PendingMessagesSummary> pending(@NonNull K var1, @NonNull String var2);

    default public Mono<PendingMessages> pending(@NonNull K key, @NonNull Consumer consumer) {
        return this.pending(key, consumer, Range.unbounded(), -1L);
    }

    public Mono<PendingMessages> pending(@NonNull K var1, @NonNull String var2, @NonNull Range<?> var3, long var4);

    public Mono<PendingMessages> pending(@NonNull K var1, @NonNull Consumer var2, @NonNull Range<?> var3, long var4);

    public Mono<Long> size(@NonNull K var1);

    default public Flux<MapRecord<K, HK, HV>> range(@NonNull K key, @NonNull Range<String> range) {
        return this.range(key, range, Limit.unlimited());
    }

    public Flux<MapRecord<K, HK, HV>> range(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public <V> Flux<ObjectRecord<K, V>> range(@NonNull Class<V> targetType, @NonNull K key, @NonNull Range<String> range) {
        return this.range(targetType, key, range, Limit.unlimited());
    }

    default public <V> Flux<ObjectRecord<K, V>> range(@NonNull Class<V> targetType, @NonNull K key, @NonNull Range<String> range, @NonNull Limit limit) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.range(key, range, limit).map(it -> this.map((MapRecord<K, HK, HV>)it, targetType));
    }

    default public Flux<MapRecord<K, HK, HV>> read(@NonNull StreamOffset<K> stream) {
        Assert.notNull(stream, (String)"StreamOffset must not be null");
        return this.read(StreamReadOptions.empty(), stream);
    }

    default public <V> Flux<ObjectRecord<K, V>> read(@NonNull Class<V> targetType, @NonNull StreamOffset<K> stream) {
        Assert.notNull(stream, (String)"StreamOffset must not be null");
        return this.read(targetType, StreamReadOptions.empty(), stream);
    }

    default public Flux<MapRecord<K, HK, HV>> read(StreamOffset<K> ... streams) {
        return this.read(StreamReadOptions.empty(), streams);
    }

    default public <V> Flux<ObjectRecord<K, V>> read(@NonNull Class<V> targetType, StreamOffset<K> ... streams) {
        return this.read(targetType, StreamReadOptions.empty(), streams);
    }

    public Flux<MapRecord<K, HK, HV>> read(@NonNull StreamReadOptions var1, StreamOffset<K> ... var2);

    default public <V> Flux<ObjectRecord<K, V>> read(@NonNull Class<V> targetType, @NonNull StreamReadOptions readOptions, StreamOffset<K> ... streams) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.read(readOptions, streams).map(it -> this.map((MapRecord<K, HK, HV>)it, targetType));
    }

    default public Flux<MapRecord<K, HK, HV>> read(@NonNull Consumer consumer, StreamOffset<K> ... streams) {
        return this.read(consumer, StreamReadOptions.empty(), streams);
    }

    default public <V> Flux<ObjectRecord<K, V>> read(@NonNull Class<V> targetType, @NonNull Consumer consumer, StreamOffset<K> ... streams) {
        return this.read(targetType, consumer, StreamReadOptions.empty(), streams);
    }

    public Flux<MapRecord<K, HK, HV>> read(@NonNull Consumer var1, @NonNull StreamReadOptions var2, StreamOffset<K> ... var3);

    default public <V> Flux<ObjectRecord<K, V>> read(@NonNull Class<V> targetType, @NonNull Consumer consumer, @NonNull StreamReadOptions readOptions, StreamOffset<K> ... streams) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.read(consumer, readOptions, streams).map(it -> this.map((MapRecord<K, HK, HV>)it, targetType));
    }

    default public Flux<MapRecord<K, HK, HV>> reverseRange(@NonNull K key, @NonNull Range<String> range) {
        return this.reverseRange(key, range, Limit.unlimited());
    }

    public Flux<MapRecord<K, HK, HV>> reverseRange(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public <V> Flux<ObjectRecord<K, V>> reverseRange(@NonNull Class<V> targetType, @NonNull K key, @NonNull Range<String> range) {
        return this.reverseRange(targetType, key, range, Limit.unlimited());
    }

    default public <V> Flux<ObjectRecord<K, V>> reverseRange(@NonNull Class<V> targetType, @NonNull K key, @NonNull Range<String> range, @NonNull Limit limit) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.reverseRange(key, range, limit).map(it -> this.map((MapRecord<K, HK, HV>)it, targetType));
    }

    public Mono<Long> trim(@NonNull K var1, long var2);

    public Mono<Long> trim(@NonNull K var1, long var2, boolean var4);

    @Override
    public <V> HashMapper<V, HK, HV> getHashMapper(@NonNull Class<V> var1);

    default public <V> ObjectRecord<K, V> map(@NonNull MapRecord<K, HK, HV> record, @NonNull Class<V> targetType) {
        Assert.notNull(record, (String)"Records must not be null");
        Assert.notNull(targetType, (String)"Target type must not be null");
        return StreamObjectMapper.toObjectRecord(record, this, targetType);
    }

    public MapRecord<K, HK, HV> deserializeRecord(@NonNull ByteBufferRecord var1);
}

