/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ReactiveClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveClusterHyperLogLogCommands
extends LettuceReactiveHyperLogLogCommands
implements ReactiveClusterHyperLogLogCommands {
    LettuceReactiveClusterHyperLogLogCommands(LettuceReactiveRedisConnection connection) {
        super(connection);
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHyperLogLogCommands.PfMergeCommand>> pfMerge(Publisher<ReactiveHyperLogLogCommands.PfMergeCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null for PFMERGE");
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty for PFMERGE");
            ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(command.getSourceKeys());
            keys.add(command.getKey());
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys.toArray(new ByteBuffer[keys.size()]))) {
                return super.pfMerge((Publisher<ReactiveHyperLogLogCommands.PfMergeCommand>)Mono.just((Object)command));
            }
            return Mono.error((Throwable)new InvalidDataAccessApiUsageException("All keys must map to same slot for PFMERGE in cluster mode"));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfCountCommand, Long>> pfCount(Publisher<ReactiveHyperLogLogCommands.PfCountCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notEmpty(command.getKeys(), (String)"Keys must be null or empty for PFCOUNT");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeys())) {
                return super.pfCount((Publisher<ReactiveHyperLogLogCommands.PfCountCommand>)Mono.just((Object)command));
            }
            return Mono.error((Throwable)new InvalidDataAccessApiUsageException("All keys must map to same slot for PFCOUNT in cluster mode"));
        }));
    }
}

