/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.util.ObjectUtils;

public interface ValueEncoding {
    public @Nullable String raw();

    public static ValueEncoding of(@Nullable String encoding) {
        return RedisValueEncoding.lookup(encoding).orElse(() -> encoding);
    }

    public static enum RedisValueEncoding implements ValueEncoding
    {
        RAW("raw"),
        INT("int"),
        ZIPLIST("ziplist"),
        LINKEDLIST("linkedlist"),
        INTSET("intset"),
        HASHTABLE("hashtable"),
        SKIPLIST("skiplist"),
        VACANT(null);

        private final @Nullable String raw;

        private RedisValueEncoding(String raw) {
            this.raw = raw;
        }

        @Override
        public @Nullable String raw() {
            return this.raw;
        }

        static Optional<ValueEncoding> lookup(@Nullable String encoding) {
            for (RedisValueEncoding valueEncoding : RedisValueEncoding.values()) {
                if (!ObjectUtils.nullSafeEquals((Object)valueEncoding.raw(), (Object)encoding)) continue;
                return Optional.of(valueEncoding);
            }
            return Optional.empty();
        }
    }
}

