/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveSubscription {
    public Mono<Void> subscribe(ByteBuffer ... var1);

    public Mono<Void> pSubscribe(ByteBuffer ... var1);

    public Mono<Void> unsubscribe();

    public Mono<Void> unsubscribe(ByteBuffer ... var1);

    public Mono<Void> pUnsubscribe();

    public Mono<Void> pUnsubscribe(ByteBuffer ... var1);

    public Set<ByteBuffer> getChannels();

    public Set<ByteBuffer> getPatterns();

    public Flux<Message<ByteBuffer, ByteBuffer>> receive();

    public Mono<Void> cancel();

    public static class PatternMessage<P, C, M>
    extends ChannelMessage<C, M> {
        private final P pattern;

        public PatternMessage(P pattern, C channel, M message) {
            super(channel, message);
            Assert.notNull(pattern, (String)"Pattern must not be null");
            this.pattern = pattern;
        }

        public P getPattern() {
            return this.pattern;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PatternMessage that = (PatternMessage)o;
            return ObjectUtils.nullSafeEquals(this.pattern, that.pattern);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.pattern);
            return result;
        }

        @Override
        public String toString() {
            return "PatternMessage{channel=" + String.valueOf(this.getChannel()) + ", pattern=" + String.valueOf(this.pattern) + ", message=" + String.valueOf(this.getMessage()) + "}";
        }
    }

    public static class ChannelMessage<C, M>
    implements Message<C, M> {
        private final C channel;
        private final M message;

        public ChannelMessage(C channel, M message) {
            Assert.notNull(channel, (String)"Channel must not be null");
            Assert.notNull(message, (String)"Message must not be null");
            this.channel = channel;
            this.message = message;
        }

        @Override
        public C getChannel() {
            return this.channel;
        }

        @Override
        public M getMessage() {
            return this.message;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChannelMessage that = (ChannelMessage)o;
            if (!ObjectUtils.nullSafeEquals(this.channel, that.channel)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.message, that.message);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.channel);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.message);
            return result;
        }

        public String toString() {
            return "ChannelMessage {channel=" + String.valueOf(this.channel) + ", message=" + String.valueOf(this.message) + "}";
        }
    }

    public static interface Message<C, M> {
        public C getChannel();

        public M getMessage();
    }
}

