/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;

class CloseSuppressingInvocationHandler
implements InvocationHandler {
    private static final String CLOSE = "close";
    private static final String HASH_CODE = "hashCode";
    private static final String EQUALS = "equals";
    private final Object target;

    public CloseSuppressingInvocationHandler(Object target) {
        this.target = target;
    }

    @Override
    public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals(EQUALS)) {
            return proxy == args[0];
        }
        if (method.getName().equals(HASH_CODE)) {
            return System.identityHashCode(proxy);
        }
        if (method.getName().equals(CLOSE)) {
            return null;
        }
        try {
            Object returnValue = method.invoke(this.target, args);
            return returnValue;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

