/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.domain.geo;

import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public interface GeoReference<T> {
    public static <T> GeoReference<T> fromMember(T member) {
        Assert.notNull(member, (String)"Geoset member must not be null");
        return new GeoMemberReference<T>(member);
    }

    public static <T> GeoReference<T> fromMember(RedisGeoCommands.GeoLocation<T> member) {
        Assert.notNull(member, (String)"GeoLocation must not be null");
        return new GeoMemberReference(member.getName());
    }

    public static <T> GeoReference<T> fromCircle(Circle within) {
        Assert.notNull((Object)within, (String)"Circle must not be null");
        return GeoReference.fromCoordinate(within.getCenter());
    }

    public static <T> GeoReference<T> fromCoordinate(double longitude, double latitude) {
        return new GeoCoordinateReference(longitude, latitude);
    }

    public static <T> GeoReference<T> fromCoordinate(RedisGeoCommands.GeoLocation<?> location) {
        Assert.notNull(location, (String)"GeoLocation must not be null");
        Assert.notNull((Object)location.getPoint(), (String)"GeoLocation point must not be null");
        return GeoReference.fromCoordinate(location.getPoint());
    }

    public static <T> GeoReference<T> fromCoordinate(Point point) {
        Assert.notNull((Object)point, (String)"Reference point must not be null");
        return GeoReference.fromCoordinate(point.getX(), point.getY());
    }

    public static class GeoMemberReference<T>
    implements GeoReference<T> {
        private final T member;

        public GeoMemberReference(T member) {
            this.member = member;
        }

        public T getMember() {
            return this.member;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GeoMemberReference)) {
                return false;
            }
            GeoMemberReference that = (GeoMemberReference)o;
            return ObjectUtils.nullSafeEquals(this.member, that.member);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.member);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [member=").append(this.member);
            sb.append(']');
            return sb.toString();
        }
    }

    public static class GeoCoordinateReference<T>
    implements GeoReference<T> {
        private final double longitude;
        private final double latitude;

        public GeoCoordinateReference(double longitude, double latitude) {
            this.longitude = longitude;
            this.latitude = latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GeoCoordinateReference)) {
                return false;
            }
            GeoCoordinateReference that = (GeoCoordinateReference)o;
            if (this.longitude != that.longitude) {
                return false;
            }
            return this.latitude == that.latitude;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.longitude);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.latitude);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [").append(this.longitude);
            sb.append(",").append(this.latitude);
            sb.append(']');
            return sb.toString();
        }
    }
}

