/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.springframework.data.redis.connection.lettuce.LettuceFutureUtils;

@FunctionalInterface
public interface LettuceConnectionProvider {
    default public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
        return (T)((StatefulConnection)LettuceFutureUtils.join(this.getConnectionAsync(connectionType)));
    }

    public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> var1);

    default public void release(StatefulConnection<?, ?> connection) {
        LettuceFutureUtils.join(this.releaseAsync(connection));
    }

    default public CompletableFuture<Void> releaseAsync(StatefulConnection<?, ?> connection) {
        return connection.closeAsync();
    }

    @FunctionalInterface
    public static interface TargetAware {
        default public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType, RedisURI redisURI) {
            return (T)((StatefulConnection)LettuceFutureUtils.join(this.getConnectionAsync(connectionType, redisURI)));
        }

        public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> var1, RedisURI var2);
    }
}

