/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyValue;
import io.lettuce.core.MapScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.async.RedisHashAsyncCommands;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceHashCommands
implements RedisHashCommands {
    private final LettuceConnection connection;

    LettuceHashCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Boolean)this.connection.invoke().just(RedisHashAsyncCommands::hset, key, field, value);
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Boolean)this.connection.invoke().just(RedisHashAsyncCommands::hsetnx, key, field, value);
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return (Long)this.connection.invoke().just(RedisHashAsyncCommands::hdel, key, fields);
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Fields must not be null");
        return (Boolean)this.connection.invoke().just(RedisHashAsyncCommands::hexists, key, field);
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return (byte[])this.connection.invoke().just(RedisHashAsyncCommands::hget, key, field);
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Map)this.connection.invoke().just(RedisHashAsyncCommands::hgetall, key);
    }

    @Override
    @Nullable
    public byte[] hRandField(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisHashAsyncCommands::hrandfield, key);
    }

    @Override
    @Nullable
    public Map.Entry<byte[], byte[]> hRandFieldWithValues(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Map.Entry)this.connection.invoke().from(RedisHashAsyncCommands::hrandfieldWithvalues, key).get(LettuceHashCommands::toEntry);
    }

    @Override
    @Nullable
    public List<byte[]> hRandField(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().just(RedisHashAsyncCommands::hrandfield, key, count);
    }

    @Override
    @Nullable
    public List<Map.Entry<byte[], byte[]>> hRandFieldWithValues(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hrandfieldWithvalues, key, count).toList(LettuceHashCommands::toEntry);
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return (Long)this.connection.invoke().just(RedisHashAsyncCommands::hincrby, key, field, delta);
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return (Double)this.connection.invoke().just(RedisHashAsyncCommands::hincrbyfloat, key, field, delta);
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hkeys, key).toSet();
    }

    @Override
    public Long hLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisHashAsyncCommands::hlen, key);
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hmget, key, fields).toList(source -> (byte[])source.getValueOrElse(null));
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(hashes, (String)"Hashes must not be null");
        this.connection.invokeStatus().just(RedisHashAsyncCommands::hmset, key, hashes);
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().just(RedisHashAsyncCommands::hvals, key);
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return this.hScan(key, Cursor.CursorId.initial(), options);
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, Cursor.CursorId cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, cursorId, options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte[] key, Cursor.CursorId cursorId, ScanOptions options) {
                if (LettuceHashCommands.this.connection.isQueueing() || LettuceHashCommands.this.connection.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'HSCAN' cannot be called in pipeline / transaction mode");
                }
                ScanCursor scanCursor = LettuceHashCommands.this.connection.getScanCursor(cursorId);
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                MapScanCursor mapScanCursor = (MapScanCursor)LettuceHashCommands.this.connection.invoke().just(RedisHashAsyncCommands::hscan, key, scanCursor, scanArgs);
                String nextCursorId = mapScanCursor.getCursor();
                Map values = mapScanCursor.getMap();
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Cursor.CursorId.of(nextCursorId), values.entrySet());
            }

            @Override
            protected void doClose() {
                LettuceHashCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    @Nullable
    public Long hStrLen(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return (Long)this.connection.invoke().just(RedisHashAsyncCommands::hstrlen, key, field);
    }

    @Nullable
    private static Map.Entry<byte[], byte[]> toEntry(KeyValue<byte[], byte[]> value) {
        return value.hasValue() ? Converters.entryOf((byte[])value.getKey(), (byte[])value.getValue()) : null;
    }
}

