/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.collections.DefaultRedisMap;
import org.springframework.data.redis.support.collections.DefaultRedisSet;
import org.springframework.data.redis.support.collections.RedisList;
import org.springframework.data.redis.support.collections.RedisProperties;
import org.springframework.data.redis.support.collections.RedisStore;
import org.springframework.data.redis.support.collections.RedisZSet;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisCollectionFactoryBean
implements InitializingBean,
BeanNameAware,
FactoryBean<RedisStore> {
    @Nullable
    private RedisStore store;
    @Nullable
    private CollectionType type = null;
    @Nullable
    private RedisTemplate<String, ?> template;
    @Nullable
    private String key;
    @Nullable
    private String beanName;

    public void afterPropertiesSet() {
        if (!StringUtils.hasText((String)this.key)) {
            this.key = this.beanName;
        }
        Assert.hasText((String)this.key, (String)"Collection key is required - no key or bean name specified");
        Assert.notNull(this.template, (String)"Redis template is required");
        DataType dt = this.template.type(this.key);
        Assert.isTrue((!DataType.STRING.equals((Object)dt) ? 1 : 0) != 0, (String)"Cannot create store on keys of type 'string'");
        this.store = this.createStore(dt);
        if (this.store == null) {
            if (this.type == null) {
                this.type = CollectionType.LIST;
            }
            this.store = this.createStore(this.type.dataType());
        }
    }

    private RedisStore createStore(DataType dt) {
        switch (dt) {
            case LIST: {
                return RedisList.create(this.key, this.template);
            }
            case SET: {
                return new DefaultRedisSet(this.key, this.template);
            }
            case ZSET: {
                return RedisZSet.create(this.key, this.template);
            }
            case HASH: {
                if (CollectionType.PROPERTIES.equals((Object)this.type)) {
                    return new RedisProperties(this.key, this.template);
                }
                return new DefaultRedisMap(this.key, this.template);
            }
        }
        return null;
    }

    public RedisStore getObject() {
        return this.store;
    }

    public Class<?> getObjectType() {
        return this.store != null ? this.store.getClass() : RedisStore.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setType(CollectionType type) {
        this.type = type;
    }

    public void setTemplate(RedisTemplate<String, ?> template) {
        this.template = template;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public static enum CollectionType {
        LIST{

            @Override
            public DataType dataType() {
                return DataType.LIST;
            }
        }
        ,
        SET{

            @Override
            public DataType dataType() {
                return DataType.SET;
            }
        }
        ,
        ZSET{

            @Override
            public DataType dataType() {
                return DataType.ZSET;
            }
        }
        ,
        MAP{

            @Override
            public DataType dataType() {
                return DataType.HASH;
            }
        }
        ,
        PROPERTIES{

            @Override
            public DataType dataType() {
                return DataType.HASH;
            }
        };


        abstract DataType dataType();
    }
}

