/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.support.collections.RedisMap;
import org.springframework.lang.Nullable;

public class DefaultRedisMap<K, V>
implements RedisMap<K, V> {
    private final BoundHashOperations<String, K, V> hashOps;

    public DefaultRedisMap(String key, RedisOperations<String, ?> operations) {
        this.hashOps = operations.boundHashOps(key);
    }

    public DefaultRedisMap(BoundHashOperations<String, K, V> boundOps) {
        this.hashOps = boundOps;
    }

    @Override
    public Long increment(K key, long delta) {
        return this.hashOps.increment(key, delta);
    }

    @Override
    public Double increment(K key, double delta) {
        return this.hashOps.increment(key, delta);
    }

    @Override
    public K randomKey() {
        return this.hashOps.randomKey();
    }

    @Override
    public Map.Entry<K, V> randomEntry() {
        return this.hashOps.randomEntry();
    }

    @Override
    public RedisOperations<String, ?> getOperations() {
        return this.hashOps.getOperations();
    }

    @Override
    public void clear() {
        this.getOperations().delete(Collections.singleton(this.getKey()));
    }

    @Override
    public boolean containsKey(Object key) {
        Boolean result = this.hashOps.hasKey(key);
        this.checkResult(result);
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map<K, V> entries = this.hashOps.entries();
        this.checkResult(entries);
        return entries.entrySet();
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.hashOps.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.hashOps.keys();
    }

    @Override
    public V put(K key, V value) {
        V oldV = this.get(key);
        this.hashOps.put(key, value);
        return oldV;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.hashOps.putAll(m);
    }

    @Override
    @Nullable
    public V remove(Object key) {
        V v = this.get(key);
        this.hashOps.delete(key);
        return v;
    }

    @Override
    public int size() {
        Long size = this.hashOps.size();
        this.checkResult(size);
        return size.intValue();
    }

    @Override
    public Collection<V> values() {
        return this.hashOps.values();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RedisMap) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 17 + this.getClass().hashCode();
        result = result * 31 + this.getKey().hashCode();
        return result;
    }

    public String toString() {
        return "RedisStore for key:" + this.getKey();
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        return this.hashOps.putIfAbsent(key, value) != false ? null : (V)this.get(key);
    }

    @Override
    public boolean remove(final Object key, final Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.hashOps.getOperations().execute(new SessionCallback<Boolean>(){

            @Override
            public Boolean execute(RedisOperations ops) {
                block1: {
                    do {
                        ops.watch(Collections.singleton(DefaultRedisMap.this.getKey()));
                        Object v = DefaultRedisMap.this.get(key);
                        if (!value.equals(v)) break block1;
                        ops.multi();
                        DefaultRedisMap.this.remove(key);
                    } while (ops.exec(ops.getHashValueSerializer()) == null);
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public boolean replace(final K key, final V oldValue, final V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        return this.hashOps.getOperations().execute(new SessionCallback<Boolean>(){

            @Override
            public Boolean execute(RedisOperations ops) {
                block1: {
                    do {
                        ops.watch(Collections.singleton(DefaultRedisMap.this.getKey()));
                        Object v = DefaultRedisMap.this.get(key);
                        if (!oldValue.equals(v)) break block1;
                        ops.multi();
                        DefaultRedisMap.this.put(key, newValue);
                    } while (ops.exec(ops.getHashValueSerializer()) == null);
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    @Nullable
    public V replace(final K key, final V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return (V)this.hashOps.getOperations().execute(new SessionCallback<V>(){

            @Override
            public V execute(RedisOperations ops) {
                block1: {
                    Object v;
                    do {
                        ops.watch(Collections.singleton(DefaultRedisMap.this.getKey()));
                        v = DefaultRedisMap.this.get(key);
                        if (v == null) break block1;
                        ops.multi();
                        DefaultRedisMap.this.put(key, value);
                    } while (ops.exec(ops.getHashValueSerializer()) == null);
                    return v;
                }
                return null;
            }
        });
    }

    @Override
    public Boolean expire(long timeout, TimeUnit unit) {
        return this.hashOps.expire(timeout, unit);
    }

    @Override
    public Boolean expireAt(Date date) {
        return this.hashOps.expireAt(date);
    }

    @Override
    public Long getExpire() {
        return this.hashOps.getExpire();
    }

    @Override
    public Boolean persist() {
        return this.hashOps.persist();
    }

    @Override
    public String getKey() {
        return (String)this.hashOps.getKey();
    }

    @Override
    public void rename(String newKey) {
        this.hashOps.rename(newKey);
    }

    @Override
    public DataType getType() {
        return this.hashOps.getType();
    }

    private void checkResult(@Nullable Object obj) {
        if (obj == null) {
            throw new IllegalStateException("Cannot read collection with Redis connection in pipeline/multi-exec mode");
        }
    }

    @Override
    public Cursor<Map.Entry<K, V>> scan() {
        return this.scan(ScanOptions.NONE);
    }

    private Cursor<Map.Entry<K, V>> scan(ScanOptions options) {
        return this.hashOps.scan(options);
    }
}

