/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.lang.Nullable;

public interface BoundGeoOperations<K, M>
extends BoundKeyOperations<K> {
    @Nullable
    public Long add(Point var1, M var2);

    @Deprecated
    @Nullable
    default public Long geoAdd(Point point, M member) {
        return this.add(point, member);
    }

    @Nullable
    public Long add(RedisGeoCommands.GeoLocation<M> var1);

    @Deprecated
    @Nullable
    default public Long geoAdd(RedisGeoCommands.GeoLocation<M> location) {
        return this.add(location);
    }

    @Nullable
    public Long add(Map<M, Point> var1);

    @Deprecated
    @Nullable
    default public Long geoAdd(Map<M, Point> memberCoordinateMap) {
        return this.add(memberCoordinateMap);
    }

    @Nullable
    public Long add(Iterable<RedisGeoCommands.GeoLocation<M>> var1);

    @Deprecated
    @Nullable
    default public Long geoAdd(Iterable<RedisGeoCommands.GeoLocation<M>> locations) {
        return this.add(locations);
    }

    @Nullable
    public Distance distance(M var1, M var2);

    @Deprecated
    @Nullable
    default public Distance geoDist(M member1, M member2) {
        return this.distance(member1, member2);
    }

    @Nullable
    public Distance distance(M var1, M var2, Metric var3);

    @Deprecated
    @Nullable
    default public Distance geoDist(M member1, M member2, Metric metric) {
        return this.distance(member1, member2, metric);
    }

    @Nullable
    public List<String> hash(M ... var1);

    @Deprecated
    @Nullable
    default public List<String> geoHash(M ... members) {
        return this.hash(members);
    }

    @Nullable
    public List<Point> position(M ... var1);

    @Deprecated
    @Nullable
    default public List<Point> geoPos(M ... members) {
        return this.position(members);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(Circle var1);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(Circle within) {
        return this.radius(within);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(Circle var1, RedisGeoCommands.GeoRadiusCommandArgs var2);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.radius(within, args);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, M var2, double var3);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, double radius) {
        return this.radius(key, member, radius);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(M var1, Distance var2);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(M member, Distance distance) {
        return this.radius(member, distance);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(M var1, Distance var2, RedisGeoCommands.GeoRadiusCommandArgs var3);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(M member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.radius(member, distance, args);
    }

    @Nullable
    public Long remove(M ... var1);

    @Deprecated
    @Nullable
    default public Long geoRemove(M ... members) {
        return this.remove(members);
    }
}

