/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.query;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.query.BoundAssignments;
import org.springframework.data.r2dbc.query.QueryMapper;
import org.springframework.data.relational.core.dialect.Escaper;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.query.Update;
import org.springframework.data.relational.core.query.ValueFunction;
import org.springframework.data.relational.core.sql.AssignValue;
import org.springframework.data.relational.core.sql.Assignment;
import org.springframework.data.relational.core.sql.Assignments;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.binding.BindMarker;
import org.springframework.r2dbc.core.binding.BindMarkers;
import org.springframework.r2dbc.core.binding.Bindings;
import org.springframework.r2dbc.core.binding.MutableBindings;
import org.springframework.util.Assert;

public class UpdateMapper
extends QueryMapper {
    public UpdateMapper(R2dbcDialect dialect, R2dbcConverter converter) {
        super(dialect, converter);
    }

    public BoundAssignments getMappedObject(BindMarkers markers, Update update, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        return this.getMappedObject(markers, update.getAssignments(), table, entity);
    }

    public BoundAssignments getMappedObject(BindMarkers markers, Map<SqlIdentifier, ? extends Object> assignments, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Assert.notNull((Object)markers, (String)"BindMarkers must not be null");
        Assert.notNull(assignments, (String)"Assignments must not be null");
        Assert.notNull((Object)table, (String)"Table must not be null");
        MutableBindings bindings = new MutableBindings(markers);
        ArrayList<Assignment> result = new ArrayList<Assignment>();
        assignments.forEach((column, value) -> {
            Assignment assignment = this.getAssignment((SqlIdentifier)column, value, bindings, table, entity);
            result.add(assignment);
        });
        return new BoundAssignments((Bindings)bindings, result);
    }

    private Assignment getAssignment(SqlIdentifier columnName, Object value, MutableBindings bindings, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Class typeHint;
        Object mappedValue;
        QueryMapper.Field propertyField = this.createPropertyField(entity, columnName, this.getMappingContext());
        Column column = table.column(propertyField.getMappedColumnName());
        TypeInformation actualType = propertyField.getTypeHint().getRequiredActualType();
        if (value instanceof Parameter) {
            Parameter parameter = (Parameter)value;
            mappedValue = this.convertValue(parameter.getValue(), propertyField.getTypeHint());
            typeHint = this.getTypeHint(mappedValue, actualType.getType(), parameter);
        } else if (value instanceof ValueFunction) {
            ValueFunction valueFunction = (ValueFunction)value;
            mappedValue = this.convertValue(valueFunction.apply(Escaper.DEFAULT), propertyField.getTypeHint());
            if (mappedValue == null) {
                return Assignments.value((Column)column, (Expression)SQL.nullLiteral());
            }
            typeHint = actualType.getType();
        } else {
            mappedValue = this.convertValue(value, propertyField.getTypeHint());
            if (mappedValue == null) {
                return Assignments.value((Column)column, (Expression)SQL.nullLiteral());
            }
            typeHint = actualType.getType();
        }
        return this.createAssignment(column, mappedValue, typeHint, bindings);
    }

    private Assignment createAssignment(Column column, Object value, Class<?> type, MutableBindings bindings) {
        BindMarker bindMarker = bindings.nextMarker(column.getName().getReference());
        AssignValue assignValue = Assignments.value((Column)column, (Expression)SQL.bindMarker((String)bindMarker.getPlaceholder()));
        if (value == null) {
            bindings.bindNull(bindMarker, type);
        } else {
            bindings.bind(bindMarker, value);
        }
        return assignValue;
    }
}

