/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.ReactiveFluentFindOperation;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.FluentQuerySupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@API(status=API.Status.INTERNAL, since="6.2")
final class ReactiveFluentQueryByPredicate<S, R>
extends FluentQuerySupport<R>
implements FluentQuery.ReactiveFluentQuery<R> {
    private final Predicate predicate;
    private final Neo4jPersistentEntity<S> metaData;
    private final ReactiveFluentFindOperation findOperation;
    private final Function<Predicate, Mono<Long>> countOperation;
    private final Function<Predicate, Mono<Boolean>> existsOperation;

    ReactiveFluentQueryByPredicate(Predicate predicate, Neo4jPersistentEntity<S> metaData, Class<R> resultType, ReactiveFluentFindOperation findOperation, Function<Predicate, Mono<Long>> countOperation, Function<Predicate, Mono<Boolean>> existsOperation) {
        this(predicate, metaData, resultType, findOperation, countOperation, existsOperation, Sort.unsorted(), null);
    }

    ReactiveFluentQueryByPredicate(Predicate predicate, Neo4jPersistentEntity<S> metaData, Class<R> resultType, ReactiveFluentFindOperation findOperation, Function<Predicate, Mono<Long>> countOperation, Function<Predicate, Mono<Boolean>> existsOperation, Sort sort, @Nullable Collection<String> properties) {
        super(resultType, sort, properties);
        this.predicate = predicate;
        this.metaData = metaData;
        this.findOperation = findOperation;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
    }

    public FluentQuery.ReactiveFluentQuery<R> sortBy(Sort sort) {
        return new ReactiveFluentQueryByPredicate<S, R>(this.predicate, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort.and(sort), this.properties);
    }

    public <NR> FluentQuery.ReactiveFluentQuery<NR> as(Class<NR> resultType) {
        return new ReactiveFluentQueryByPredicate<S, NR>(this.predicate, this.metaData, resultType, this.findOperation, this.countOperation, this.existsOperation);
    }

    public FluentQuery.ReactiveFluentQuery<R> project(Collection<String> properties) {
        return new ReactiveFluentQueryByPredicate<S, R>(this.predicate, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort, this.mergeProperties(properties));
    }

    public Mono<R> one() {
        return this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forCondition(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), null, CypherAdapterUtils.toSortItems(this.metaData, this.sort), this.createIncludedFieldsPredicate())).one();
    }

    public Mono<R> first() {
        return this.all().take(1L).singleOrEmpty();
    }

    public Flux<R> all() {
        return this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forCondition(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), null, CypherAdapterUtils.toSortItems(this.metaData, this.sort), this.createIncludedFieldsPredicate())).all();
    }

    public Mono<Page<R>> page(Pageable pageable) {
        Flux results = this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forCondition(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), pageable, null, this.createIncludedFieldsPredicate())).all();
        return results.collectList().zipWith(this.countOperation.apply(this.predicate)).map(tuple -> {
            Page page = PageableExecutionUtils.getPage((List)((List)tuple.getT1()), (Pageable)pageable, () -> (Long)tuple.getT2());
            return page;
        });
    }

    public Mono<Long> count() {
        return this.countOperation.apply(this.predicate);
    }

    public Mono<Boolean> exists() {
        return this.existsOperation.apply(this.predicate);
    }
}

