/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescription;

@API(status=API.Status.INTERNAL, since="6.0")
public final class CypherAdapterUtils {
    public static Function<Sort.Order, SortItem> sortAdapterFor(NodeDescription<?> nodeDescription) {
        return order -> {
            SymbolicName root;
            String domainProperty = order.getProperty();
            boolean propertyIsQualified = domainProperty.contains(".");
            if (!propertyIsQualified) {
                root = Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription);
            } else {
                int indexOfSeparator = domainProperty.indexOf(".");
                root = Cypher.name((String)domainProperty.substring(0, indexOfSeparator));
                domainProperty = domainProperty.substring(indexOfSeparator + 1);
            }
            String graphProperty = nodeDescription.getGraphProperty(domainProperty).map(GraphPropertyDescription::getPropertyName).orElseThrow(() -> new IllegalStateException(String.format("Cannot order by the unknown graph property: '%s'", order.getProperty())));
            Property expression = Cypher.property((Expression)root, (String[])new String[]{graphProperty});
            if (order.isIgnoreCase()) {
                expression = Functions.toLower((Expression)expression);
            }
            SortItem sortItem = Cypher.sort((Expression)expression);
            if (order.isDescending()) {
                sortItem = sortItem.descending();
            }
            return sortItem;
        };
    }

    public static Collection<SortItem> toSortItems(NodeDescription<?> nodeDescription, Sort sort) {
        return sort.stream().map(CypherAdapterUtils.sortAdapterFor(nodeDescription)).collect(Collectors.toList());
    }

    public static StatementBuilder.BuildableStatement addPagingParameter(NodeDescription<?> nodeDescription, Pageable pageable, StatementBuilder.OngoingReadingAndReturn returning) {
        Sort sort = pageable.getSort();
        long skip = pageable.getOffset();
        int pageSize = pageable.getPageSize();
        return returning.orderBy(CypherAdapterUtils.toSortItems(nodeDescription, sort)).skip((Number)skip).limit((Number)pageSize);
    }

    private CypherAdapterUtils() {
    }
}

