/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0.4")
public final class QueryFragments {
    private List<PatternElement> matchOn = new ArrayList<PatternElement>();
    private Condition condition;
    private List<Expression> returnExpressions = new ArrayList<Expression>();
    private SortItem[] orderBy;
    private Number limit;
    private Long skip;
    private ReturnTuple returnTuple;
    private boolean scalarValueReturn = false;
    private boolean renderConstantsAsParameters = false;

    public void addMatchOn(PatternElement match) {
        this.matchOn.add(match);
    }

    public void setMatchOn(List<PatternElement> match) {
        this.matchOn = match;
    }

    public List<PatternElement> getMatchOn() {
        return this.matchOn;
    }

    public void setCondition(@Nullable Condition condition) {
        this.condition = Optional.ofNullable(condition).orElse(Conditions.noCondition());
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setReturnExpressions(Expression[] expression) {
        this.returnExpressions = Arrays.asList(expression);
    }

    public void setReturnExpression(Expression returnExpression, boolean isScalarValue) {
        this.returnExpressions = Collections.singletonList(returnExpression);
        this.scalarValueReturn = isScalarValue;
    }

    public boolean includeField(String fieldName) {
        return this.returnTuple == null || this.returnTuple.includedProperties.isEmpty() || this.returnTuple.includedProperties.contains(fieldName);
    }

    public void setOrderBy(SortItem[] orderBy) {
        this.orderBy = orderBy;
    }

    public void setLimit(Number limit) {
        this.limit = limit;
    }

    public void setSkip(Long skip) {
        this.skip = skip;
    }

    public void setReturnBasedOn(NodeDescription<?> nodeDescription, List<String> includedProperties, boolean isDistinct) {
        this.returnTuple = new ReturnTuple(nodeDescription, includedProperties, isDistinct);
    }

    public ReturnTuple getReturnTuple() {
        return this.returnTuple;
    }

    public boolean isScalarValueReturn() {
        return this.scalarValueReturn;
    }

    public boolean isRenderConstantsAsParameters() {
        return this.renderConstantsAsParameters;
    }

    public void setRenderConstantsAsParameters(boolean renderConstantsAsParameters) {
        this.renderConstantsAsParameters = renderConstantsAsParameters;
    }

    public Statement toStatement() {
        StatementBuilder.OngoingReadingWithoutWhere match = null;
        for (PatternElement patternElement : this.matchOn) {
            if (match == null) {
                match = Cypher.match((PatternElement[])new PatternElement[]{this.matchOn.get(0)});
                continue;
            }
            match = match.match(new PatternElement[]{patternElement});
        }
        StatementBuilder.OngoingReadingWithWhere matchWithWhere = match.where(this.condition);
        StatementBuilder.OngoingReadingAndReturn returnPart = this.isDistinctReturn() ? matchWithWhere.returningDistinct(this.getReturnExpressions()) : matchWithWhere.returning(this.getReturnExpressions());
        Statement statement = returnPart.orderBy(this.getOrderBy()).skip((Number)this.skip).limit(this.limit).build();
        statement.setRenderConstantsAsParameters(this.renderConstantsAsParameters);
        return statement;
    }

    private Expression[] getReturnExpressions() {
        return this.returnExpressions.size() > 0 ? this.returnExpressions.toArray(new Expression[0]) : CypherGenerator.INSTANCE.createReturnStatementForMatch(this.getReturnTuple().nodeDescription, this::includeField);
    }

    private boolean isDistinctReturn() {
        return this.returnExpressions.isEmpty() && this.getReturnTuple().isDistinct;
    }

    public SortItem[] getOrderBy() {
        return this.orderBy != null ? this.orderBy : new SortItem[]{};
    }

    public Number getLimit() {
        return this.limit;
    }

    public Long getSkip() {
        return this.skip;
    }

    static final class ReturnTuple {
        final NodeDescription<?> nodeDescription;
        final Set<String> includedProperties;
        final boolean isDistinct;

        private ReturnTuple(NodeDescription<?> nodeDescription, List<String> includedProperties, boolean isDistinct) {
            this.nodeDescription = nodeDescription;
            this.includedProperties = includedProperties == null ? Collections.emptySet() : new HashSet<String>(includedProperties);
            this.isDistinct = isDistinct;
        }
    }
}

