/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.neo4j.driver.Bookmark;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.neo4j.core.transaction.Neo4jBookmarksUpdatedEvent;
import org.springframework.lang.Nullable;

@API(status=API.Status.STABLE, since="6.1.1")
public final class Neo4jBookmarkManager {
    private final Set<Bookmark> bookmarks = new HashSet<Bookmark>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();
    private final Supplier<Set<Bookmark>> bookmarksSupplier;
    @Nullable
    private ApplicationEventPublisher applicationEventPublisher;

    public static Neo4jBookmarkManager create() {
        return new Neo4jBookmarkManager(null);
    }

    public static Neo4jBookmarkManager create(@Nullable Supplier<Set<Bookmark>> bookmarksSupplier) {
        return new Neo4jBookmarkManager(bookmarksSupplier);
    }

    private Neo4jBookmarkManager(@Nullable Supplier<Set<Bookmark>> bookmarksSupplier) {
        this.bookmarksSupplier = bookmarksSupplier == null ? () -> Collections.emptySet() : bookmarksSupplier;
    }

    Collection<Bookmark> getBookmarks() {
        try {
            this.read.lock();
            HashSet<Bookmark> bookmarksToUse = new HashSet<Bookmark>(this.bookmarks);
            bookmarksToUse.addAll((Collection<Bookmark>)this.bookmarksSupplier.get());
            Set<Bookmark> set = Collections.unmodifiableSet(bookmarksToUse);
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    void updateBookmarks(Collection<Bookmark> usedBookmarks, Bookmark lastBookmark) {
        try {
            this.write.lock();
            this.bookmarks.removeAll(usedBookmarks);
            this.bookmarks.add(lastBookmark);
            if (this.applicationEventPublisher != null) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new Neo4jBookmarksUpdatedEvent(new HashSet<Bookmark>(this.bookmarks)));
            }
        }
        finally {
            this.write.unlock();
        }
    }

    void setApplicationEventPublisher(@Nullable ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

