/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jIsNewStrategy;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.DynamicLabels;
import org.springframework.data.neo4j.core.schema.GeneratedValue;
import org.springframework.data.neo4j.core.schema.IdGenerator;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.Property;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.springframework.data.neo4j.core.schema.RelationshipProperties;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class DefaultNeo4jPersistentEntity<T>
extends BasicPersistentEntity<T, Neo4jPersistentProperty>
implements Neo4jPersistentEntity<T> {
    private static final Set<Class<?>> VALID_GENERATED_ID_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Long.class, Long.TYPE)));
    private final String primaryLabel;
    private final Lazy<List<String>> additionalLabels;
    private final Lazy<IdDescription> idDescription;
    private final Lazy<Collection<GraphPropertyDescription>> graphProperties;
    private final Set<NodeDescription<?>> childNodeDescriptions = new HashSet();
    private NodeDescription<?> parentNodeDescription;
    private final Lazy<Neo4jPersistentProperty> dynamicLabelsProperty;
    private final Lazy<Boolean> isRelationshipPropertiesEntity;

    DefaultNeo4jPersistentEntity(TypeInformation<T> information) {
        super(information);
        this.primaryLabel = DefaultNeo4jPersistentEntity.computePrimaryLabel(this.getType());
        this.additionalLabels = Lazy.of(this::computeAdditionalLabels);
        this.graphProperties = Lazy.of(this::computeGraphProperties);
        this.dynamicLabelsProperty = Lazy.of(() -> this.getGraphProperties().stream().map(Neo4jPersistentProperty.class::cast).filter(Neo4jPersistentProperty::isDynamicLabels).findFirst().orElse(null));
        this.isRelationshipPropertiesEntity = Lazy.of(() -> this.isAnnotationPresent(RelationshipProperties.class));
        this.idDescription = Lazy.of(this::computeIdDescription);
    }

    @Override
    public String getPrimaryLabel() {
        return this.primaryLabel;
    }

    @Override
    public String getMostAbstractParentLabel(NodeDescription<?> mostAbstractNodeDescription) {
        return this.getMostAbstractParent(mostAbstractNodeDescription).getPrimaryLabel();
    }

    private NodeDescription<?> getMostAbstractParent(NodeDescription<?> mostAbstractNodeDescription) {
        NodeDescription<?> parent;
        if (mostAbstractNodeDescription.equals(this)) {
            return this;
        }
        NodeDescription<Object> mostAbstractParent = this;
        do {
            if ((parent = mostAbstractParent.getParentNodeDescription()) == null) {
                return mostAbstractParent;
            }
            mostAbstractParent = parent;
        } while (!mostAbstractNodeDescription.equals(parent));
        return mostAbstractNodeDescription;
    }

    @Override
    public Class<T> getUnderlyingClass() {
        return this.getType();
    }

    @Override
    @Nullable
    public IdDescription getIdDescription() {
        return (IdDescription)this.idDescription.getNullable();
    }

    @Override
    public Collection<GraphPropertyDescription> getGraphProperties() {
        return (Collection)this.graphProperties.get();
    }

    @Override
    public List<String> getAdditionalLabels() {
        return (List)this.additionalLabels.get();
    }

    @Override
    public Optional<GraphPropertyDescription> getGraphProperty(String fieldName) {
        return Optional.ofNullable(this.getPersistentProperty(fieldName));
    }

    @Override
    public Optional<Neo4jPersistentProperty> getDynamicLabelsProperty() {
        return this.dynamicLabelsProperty.getOptional();
    }

    @Override
    public boolean isRelationshipPropertiesEntity() {
        return (Boolean)this.isRelationshipPropertiesEntity.get();
    }

    protected IsNewStrategy getFallbackIsNewStrategy() {
        return DefaultNeo4jIsNewStrategy.basedOn(this);
    }

    public void verify() {
        super.verify();
        this.verifyIdDescription();
        this.verifyNoDuplicatedGraphProperties();
        this.verifyDynamicAssociations();
        this.verifyAssociationsWithProperties();
        this.verifyDynamicLabels();
    }

    private void verifyIdDescription() {
        if (this.describesInterface()) {
            return;
        }
        if (this.getIdDescription() == null && (this.isAnnotationPresent(Node.class) || this.isAnnotationPresent(Persistent.class))) {
            throw new IllegalStateException("Missing id property on " + this.getUnderlyingClass() + ".");
        }
    }

    private void verifyNoDuplicatedGraphProperties() {
        HashSet seen = new HashSet();
        HashSet duplicates = new HashSet();
        this.doWithProperties(persistentProperty -> {
            String propertyName = persistentProperty.getPropertyName();
            if (seen.contains(propertyName)) {
                duplicates.add(propertyName);
            } else {
                seen.add(propertyName);
            }
        });
        Assert.state((boolean)duplicates.isEmpty(), () -> String.format("Duplicate definition of propert%s %s in entity %s.", duplicates.size() == 1 ? "y" : "ies", duplicates, this.getUnderlyingClass()));
    }

    private void verifyDynamicAssociations() {
        HashSet targetEntities = new HashSet();
        this.doWithAssociations(association -> {
            Neo4jPersistentProperty inverse = (Neo4jPersistentProperty)association.getInverse();
            if (inverse.isDynamicAssociation()) {
                Relationship relationship = (Relationship)inverse.findAnnotation(Relationship.class);
                Assert.state((relationship == null || relationship.type().isEmpty() ? 1 : 0) != 0, () -> "Dynamic relationships cannot be used with a fixed type. Omit @Relationship or use @Relationship(direction = " + relationship.direction().name() + ") without a type in " + this.getUnderlyingClass() + " on field " + inverse.getFieldName() + ".");
                Assert.state((!targetEntities.contains(inverse.getAssociationTargetType()) ? 1 : 0) != 0, () -> this.getUnderlyingClass() + " already contains a dynamic relationship to " + inverse.getAssociationTargetType() + ". Only one dynamic relationship between to entities is permitted.");
                targetEntities.add(inverse.getAssociationTargetType());
            }
        });
    }

    private void verifyAssociationsWithProperties() {
        this.doWithAssociations(association -> {
            RelationshipDescription relationship;
            if (association instanceof RelationshipDescription && (relationship = (RelationshipDescription)association).hasRelationshipProperties()) {
                NodeDescription<?> relationshipPropertiesEntity = relationship.getRelationshipPropertiesEntity();
                Supplier<String> messageSupplier = () -> String.format("The target class `%s` for the properties of the relationship `%s` is missing a property for the generated, internal ID (`@Id @GeneratedValue Long id`) which is needed for safely updating properties.", relationshipPropertiesEntity.getUnderlyingClass().getName(), relationship.getType());
                Assert.state((relationshipPropertiesEntity.getIdDescription() != null && relationshipPropertiesEntity.getIdDescription().isInternallyGeneratedId() ? 1 : 0) != 0, messageSupplier);
            }
        });
    }

    private void verifyDynamicLabels() {
        HashSet namesOfPropertiesWithDynamicLabels = new HashSet();
        this.doWithProperties(persistentProperty -> {
            if (!persistentProperty.isAnnotationPresent(DynamicLabels.class)) {
                return;
            }
            String propertyName = persistentProperty.getPropertyName();
            namesOfPropertiesWithDynamicLabels.add(propertyName);
            Assert.state((boolean)persistentProperty.isCollectionLike(), () -> String.format("Property %s on %s must extends %s.", persistentProperty.getFieldName(), persistentProperty.getOwner().getType(), Collection.class.getName()));
        });
        Assert.state((namesOfPropertiesWithDynamicLabels.size() <= 1 ? 1 : 0) != 0, () -> String.format("Multiple properties in entity %s are annotated with @%s: %s.", this.getUnderlyingClass(), DynamicLabels.class.getSimpleName(), namesOfPropertiesWithDynamicLabels));
    }

    @Nullable
    static String computePrimaryLabel(Class<?> type) {
        Node nodeAnnotation = (Node)AnnotatedElementUtils.findMergedAnnotation(type, Node.class);
        if (nodeAnnotation == null || DefaultNeo4jPersistentEntity.hasEmptyLabelInformation(nodeAnnotation)) {
            return type.getSimpleName();
        }
        if (StringUtils.hasText((String)nodeAnnotation.primaryLabel())) {
            return nodeAnnotation.primaryLabel();
        }
        return nodeAnnotation.labels()[0];
    }

    private List<String> computeAdditionalLabels() {
        return Stream.concat(this.computeOwnAdditionalLabels().stream(), this.computeParentLabels().stream()).distinct().filter(v -> !this.getPrimaryLabel().equals(v)).collect(Collectors.toList());
    }

    @NonNull
    private List<String> computeOwnAdditionalLabels() {
        ArrayList<String> result = new ArrayList<String>();
        Node nodeAnnotation = (Node)this.findAnnotation(Node.class);
        if (nodeAnnotation != null && !DefaultNeo4jPersistentEntity.hasEmptyLabelInformation(nodeAnnotation)) {
            if (StringUtils.hasText((String)nodeAnnotation.primaryLabel())) {
                result.addAll(Arrays.asList(nodeAnnotation.labels()));
            } else {
                result.addAll(Arrays.asList(Arrays.copyOfRange(nodeAnnotation.labels(), 1, nodeAnnotation.labels().length)));
            }
        }
        for (Class<?> anInterface : this.getType().getInterfaces()) {
            nodeAnnotation = (Node)AnnotatedElementUtils.findMergedAnnotation(anInterface, Node.class);
            if (nodeAnnotation == null) continue;
            if (DefaultNeo4jPersistentEntity.hasEmptyLabelInformation(nodeAnnotation)) {
                result.add(anInterface.getSimpleName());
                continue;
            }
            if (StringUtils.hasText((String)nodeAnnotation.primaryLabel())) {
                result.add(nodeAnnotation.primaryLabel());
            }
            result.addAll(Arrays.asList(nodeAnnotation.labels()));
        }
        return Collections.unmodifiableList(result);
    }

    @NonNull
    private List<String> computeParentLabels() {
        ArrayList<String> parentLabels = new ArrayList<String>();
        for (Neo4jPersistentEntity parentNodeDescriptionCalculated = (Neo4jPersistentEntity)this.parentNodeDescription; parentNodeDescriptionCalculated != null; parentNodeDescriptionCalculated = (Neo4jPersistentEntity)parentNodeDescriptionCalculated.getParentNodeDescription()) {
            if (!DefaultNeo4jPersistentEntity.isExplicitlyAnnotatedAsEntity(parentNodeDescriptionCalculated)) continue;
            parentLabels.add(parentNodeDescriptionCalculated.getPrimaryLabel());
            parentLabels.addAll(parentNodeDescriptionCalculated.getAdditionalLabels());
        }
        return parentLabels;
    }

    private static boolean isExplicitlyAnnotatedAsEntity(Neo4jPersistentEntity<?> entity) {
        return entity.isAnnotationPresent(Node.class) || entity.isAnnotationPresent(Persistent.class);
    }

    @Override
    public boolean describesInterface() {
        return this.getTypeInformation().getRawTypeInformation().getType().isInterface();
    }

    private static boolean hasEmptyLabelInformation(Node nodeAnnotation) {
        return nodeAnnotation.labels().length < 1 && !StringUtils.hasText((String)nodeAnnotation.primaryLabel());
    }

    @Nullable
    private IdDescription computeIdDescription() {
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)this.getIdProperty();
        if (idProperty == null) {
            return null;
        }
        GeneratedValue generatedValueAnnotation = (GeneratedValue)idProperty.findAnnotation(GeneratedValue.class);
        String propertyName = idProperty.getPropertyName();
        if (generatedValueAnnotation == null) {
            return IdDescription.forAssignedIds(propertyName);
        }
        Class<IdGenerator<Object>> idGeneratorClass = generatedValueAnnotation.generatorClass();
        String idGeneratorRef = generatedValueAnnotation.generatorRef();
        if (idProperty.getActualType() == UUID.class && idGeneratorClass == GeneratedValue.InternalIdGenerator.class && !StringUtils.hasText((String)idGeneratorRef)) {
            idGeneratorClass = GeneratedValue.UUIDGenerator.class;
        }
        if (idGeneratorClass == GeneratedValue.InternalIdGenerator.class && idGeneratorRef.isEmpty()) {
            if (idProperty.findAnnotation(Property.class) != null) {
                throw new IllegalArgumentException("Cannot use internal id strategy with custom property " + propertyName + " on entity class " + this.getUnderlyingClass().getName());
            }
            if (!VALID_GENERATED_ID_TYPES.contains(idProperty.getActualType())) {
                throw new IllegalArgumentException("Internally generated ids can only be assigned to one of " + VALID_GENERATED_ID_TYPES);
            }
            return IdDescription.forInternallyGeneratedIds();
        }
        return IdDescription.forExternallyGeneratedIds(idGeneratorClass, idGeneratorRef, propertyName);
    }

    @Override
    public Collection<RelationshipDescription> getRelationships() {
        ArrayList relationships = new ArrayList();
        this.doWithAssociations(association -> relationships.add((RelationshipDescription)association));
        return Collections.unmodifiableCollection(relationships);
    }

    @Override
    @NonNull
    public Collection<RelationshipDescription> getRelationshipsInHierarchy(Predicate<String> propertyFilter) {
        HashSet<RelationshipDescription> relationships = new HashSet<RelationshipDescription>(this.getRelationships());
        for (NodeDescription childDescription : this.getChildNodeDescriptionsInHierarchy()) {
            childDescription.getRelationships().forEach(concreteRelationship -> {
                String fieldName = concreteRelationship.getFieldName();
                if (relationships.stream().noneMatch(relationship -> relationship.getFieldName().equals(fieldName))) {
                    relationships.add((RelationshipDescription)concreteRelationship);
                }
            });
        }
        return relationships.stream().filter(relationshipDescription -> propertyFilter.test(relationshipDescription.getFieldName())).collect(Collectors.toSet());
    }

    private Collection<GraphPropertyDescription> computeGraphProperties() {
        ArrayList computedGraphProperties = new ArrayList();
        this.doWithProperties(computedGraphProperties::add);
        return Collections.unmodifiableCollection(computedGraphProperties);
    }

    @Override
    public Collection<GraphPropertyDescription> getGraphPropertiesInHierarchy() {
        TreeSet<GraphPropertyDescription> allPropertiesInHierarchy = new TreeSet<GraphPropertyDescription>(Comparator.comparing(GraphPropertyDescription::getPropertyName));
        allPropertiesInHierarchy.addAll(this.getGraphProperties());
        for (NodeDescription childNodeDescription : this.getChildNodeDescriptionsInHierarchy()) {
            Collection<GraphPropertyDescription> childGraphProperties = childNodeDescription.getGraphProperties();
            allPropertiesInHierarchy.addAll(childGraphProperties);
        }
        return allPropertiesInHierarchy;
    }

    @Override
    public void addChildNodeDescription(NodeDescription<?> child) {
        this.childNodeDescriptions.add(child);
    }

    @Override
    public Set<NodeDescription<?>> getChildNodeDescriptionsInHierarchy() {
        HashSet childNodes = new HashSet(this.childNodeDescriptions);
        for (NodeDescription<?> childNodeDescription : this.childNodeDescriptions) {
            childNodes.addAll(childNodeDescription.getChildNodeDescriptionsInHierarchy());
        }
        return childNodes;
    }

    @Override
    public void setParentNodeDescription(NodeDescription<?> parent) {
        this.parentNodeDescription = parent;
    }

    @Override
    @Nullable
    public NodeDescription<?> getParentNodeDescription() {
        return this.parentNodeDescription;
    }

    @Override
    public boolean containsPossibleCircles(Predicate<String> includeField) {
        return this.calculatePossibleCircles(includeField);
    }

    private boolean calculatePossibleCircles(Predicate<String> includeField) {
        HashSet<RelationshipDescription> relationships = new HashSet<RelationshipDescription>(this.getRelationshipsInHierarchy(includeField));
        HashSet<RelationshipDescription> processedRelationships = new HashSet<RelationshipDescription>();
        for (RelationshipDescription relationship : relationships) {
            if (!includeField.test(relationship.getFieldName())) continue;
            if (processedRelationships.contains(relationship)) {
                return true;
            }
            processedRelationships.add(relationship);
            if (!this.calculatePossibleCircles(relationship.getTarget(), processedRelationships)) continue;
            return true;
        }
        return false;
    }

    private boolean calculatePossibleCircles(NodeDescription<?> nodeDescription, Set<RelationshipDescription> processedRelationships) {
        Collection<RelationshipDescription> relationships = nodeDescription.getRelationshipsInHierarchy(s -> true);
        for (RelationshipDescription relationship : relationships) {
            if (processedRelationships.contains(relationship)) {
                return true;
            }
            processedRelationships.add(relationship);
            if (!this.calculatePossibleCircles(relationship.getTarget(), processedRelationships)) continue;
            return true;
        }
        return false;
    }
}

