/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.function.BiFunction;
import org.neo4j.driver.Record;
import org.neo4j.driver.types.TypeSystem;

class DelegatingMappingFunctionWithNullCheck<T>
implements BiFunction<TypeSystem, Record, T> {
    BiFunction<TypeSystem, Record, T> delegate;

    DelegatingMappingFunctionWithNullCheck(BiFunction<TypeSystem, Record, T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T apply(TypeSystem typeSystem, Record record) {
        T t = this.delegate.apply(typeSystem, record);
        if (t == null) {
            throw new IllegalStateException("Mapping function " + this.delegate + " returned illegal null value for record " + record);
        }
        return t;
    }
}

