/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.ReactiveMongoRepositoryFragmentsContributor;
import org.springframework.data.mongodb.repository.support.ReactiveQuerydslMongoPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;

enum ReactiveQuerydslContributor implements ReactiveMongoRepositoryFragmentsContributor
{
    INSTANCE;


    @Override
    public RepositoryComposition.RepositoryFragments contribute(RepositoryMetadata metadata, MongoEntityInformation<?, ?> entityInformation, ReactiveMongoOperations operations) {
        if (ReactiveQuerydslContributor.isQuerydslRepository(metadata)) {
            ReactiveQuerydslMongoPredicateExecutor executor = new ReactiveQuerydslMongoPredicateExecutor(entityInformation, operations);
            return RepositoryComposition.RepositoryFragments.of((RepositoryFragment[])new RepositoryFragment[]{RepositoryFragment.implemented(ReactiveQuerydslPredicateExecutor.class, executor)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    public RepositoryComposition.RepositoryFragments describe(RepositoryMetadata metadata) {
        if (ReactiveQuerydslContributor.isQuerydslRepository(metadata)) {
            return RepositoryComposition.RepositoryFragments.of((RepositoryFragment[])new RepositoryFragment[]{RepositoryFragment.structural(ReactiveQuerydslPredicateExecutor.class, ReactiveQuerydslMongoPredicateExecutor.class)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    private static boolean isQuerydslRepository(RepositoryMetadata metadata) {
        return QuerydslUtils.QUERY_DSL_PRESENT && ReactiveQuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
    }
}

