/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import com.mongodb.MongoClientSettings;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import org.bson.AbstractBsonWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;
import org.bson.json.StrictJsonWriter;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.core.query.GeoCommand;
import org.springframework.data.mongodb.repository.aot.AotPlaceholders;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class DocumentSerializer {
    private static final CodecRegistry JSON_CODEC_REGISTRY = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PlaceholderCodecProvider.INSTACE}), MongoClientSettings.getDefaultCodecRegistry()});
    private static final Codec<Document> DOCUMENT_CODEC = JSON_CODEC_REGISTRY.get(Document.class);

    DocumentSerializer() {
    }

    public static String toJson(Document document) {
        PlaceholderJsonWriter writer = new PlaceholderJsonWriter();
        DOCUMENT_CODEC.encode((BsonWriter)writer, (Object)document, EncoderContext.builder().build());
        return writer.getWriter().getBuffer().toString();
    }

    @NullUnmarked
    static class PlaceholderJsonWriter
    extends JsonWriter
    implements BsonWriter {
        private static final Field JSON_WRITER = ReflectionUtils.findField(JsonWriter.class, (String)"strictJsonWriter");
        private final StrictJsonWriter jsonWriter;

        public PlaceholderJsonWriter() {
            super((Writer)new StringWriter(), JsonWriterSettings.builder().outputMode(JsonMode.SHELL).build());
            if (JSON_WRITER == null) {
                throw new IllegalStateException("Cannot resolve 'JsonWriter.strictJsonWriter' field");
            }
            ReflectionUtils.makeAccessible((Field)JSON_WRITER);
            this.jsonWriter = (StrictJsonWriter)ReflectionUtils.getField((Field)JSON_WRITER, (Object)((Object)this));
        }

        public StringWriter getWriter() {
            return (StringWriter)super.getWriter();
        }

        public void writePlaceholder(String placeholder) {
            this.checkPreconditions("writePlaceholder", new AbstractBsonWriter.State[]{AbstractBsonWriter.State.VALUE});
            this.jsonWriter.writeRaw(placeholder);
            this.setState(this.getNextState());
        }
    }

    @NullUnmarked
    static enum PlaceholderCodecProvider implements CodecProvider
    {
        INSTACE;


        public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
            if (ClassUtils.isAssignable(AotPlaceholders.Placeholder.class, clazz)) {
                return PlaceholderCodec.INSTANCE;
            }
            if (ClassUtils.isAssignable(GeoCommand.class, clazz)) {
                return GeoCommandCodec.INSTANCE;
            }
            return null;
        }
    }

    static enum GeoCommandCodec implements Codec<GeoCommand>
    {
        INSTANCE;


        public GeoCommand decode(BsonReader reader, DecoderContext decoderContext) {
            throw new UnsupportedOperationException("decode is not supported for GeoCommandCodec");
        }

        public void encode(BsonWriter writer, GeoCommand value, EncoderContext encoderContext) {
            if (writer instanceof PlaceholderJsonWriter) {
                PlaceholderJsonWriter sjw = (PlaceholderJsonWriter)writer;
                if (!value.getCommand().equals("$geometry")) {
                    writer.writeStartDocument();
                    writer.writeName(value.getCommand());
                    Shape shape = value.getShape();
                    if (shape instanceof AotPlaceholders.Placeholder) {
                        AotPlaceholders.Placeholder p = (AotPlaceholders.Placeholder)shape;
                        sjw.writePlaceholder(p.toString());
                    }
                    writer.writeEndDocument();
                } else {
                    Shape shape = value.getShape();
                    if (shape instanceof AotPlaceholders.Placeholder) {
                        AotPlaceholders.Placeholder p = (AotPlaceholders.Placeholder)shape;
                        sjw.writePlaceholder(p.toString());
                    }
                }
            } else {
                writer.writeString(value.getCommand(), value.getShape().toString());
            }
        }

        public Class<GeoCommand> getEncoderClass() {
            return GeoCommand.class;
        }
    }

    @NullUnmarked
    static enum PlaceholderCodec implements Codec<AotPlaceholders.Placeholder>
    {
        INSTANCE;


        public AotPlaceholders.Placeholder decode(BsonReader reader, DecoderContext decoderContext) {
            throw new UnsupportedOperationException("decode is not supported for PlaceholderCodec");
        }

        public void encode(BsonWriter writer, AotPlaceholders.Placeholder value, EncoderContext encoderContext) {
            if (writer instanceof PlaceholderJsonWriter) {
                PlaceholderJsonWriter sjw = (PlaceholderJsonWriter)writer;
                sjw.writePlaceholder(value.toString());
            } else {
                writer.writeString(value.toString());
            }
        }

        public Class<AotPlaceholders.Placeholder> getEncoderClass() {
            return AotPlaceholders.Placeholder.class;
        }
    }
}

