/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import com.mongodb.DBRef;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.conversions.Bson;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Vector;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.VectorSearch;
import org.springframework.data.mongodb.repository.aot.AotPlaceholders;
import org.springframework.data.mongodb.repository.aot.AotStringQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryCreator;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

record AotQueryCreator(MappingContext<?, MongoPersistentProperty> mappingContext) {
    AotStringQuery createQuery(PartTree partTree, QueryMethod queryMethod, Method source) {
        MongoQueryMethod mqm;
        MongoQueryMethod mqm2;
        boolean geoNear;
        boolean bl = geoNear = queryMethod instanceof MongoQueryMethod && (mqm2 = (MongoQueryMethod)queryMethod).isGeoNearQuery();
        boolean searchQuery = queryMethod instanceof MongoQueryMethod ? (mqm = (MongoQueryMethod)queryMethod).isSearchQuery() || source.isAnnotationPresent(VectorSearch.class) : source.isAnnotationPresent(VectorSearch.class);
        PlaceholderParameterAccessor placeholderAccessor = new PlaceholderParameterAccessor(partTree, queryMethod);
        Query query = (Query)new AotMongoQueryCreator(partTree, new PlaceholderConvertingParameterAccessor(placeholderAccessor), this.mappingContext, geoNear, searchQuery).createQuery();
        if (partTree.isLimiting()) {
            query.limit(partTree.getMaxResults());
        }
        return new AotStringQuery(query, placeholderAccessor.getPlaceholders());
    }

    @NullUnmarked
    static class PlaceholderParameterAccessor
    implements MongoParameterAccessor {
        private final List<AotPlaceholders.Placeholder> placeholders;

        @Nullable Part getPartForIndex(PartTree partTree, Parameter parameter) {
            if (!parameter.isBindable()) {
                return null;
            }
            List parts = partTree.getParts().stream().toList();
            int counter = 0;
            for (Part part : parts) {
                if (counter == parameter.getIndex()) {
                    return part;
                }
                counter += part.getNumberOfArguments();
            }
            return null;
        }

        public PlaceholderParameterAccessor(PartTree partTree, QueryMethod queryMethod) {
            Parameters parameters = queryMethod.getParameters();
            if (parameters.getNumberOfParameters() == 0) {
                this.placeholders = List.of();
            } else {
                this.placeholders = new ArrayList<AotPlaceholders.Placeholder>(parameters.getNumberOfParameters());
                for (Parameter parameter : parameters.toList()) {
                    int index = parameter.getIndex();
                    this.placeholders.add(index, this.getPlaceholder(index, parameter, partTree));
                }
            }
        }

        private AotPlaceholders.Placeholder getPlaceholder(int index, Parameter parameter, PartTree partTree) {
            Class type = parameter.getType();
            if (GeoJson.class.isAssignableFrom(type)) {
                return AotPlaceholders.geoJson(index, "");
            }
            if (Point.class.isAssignableFrom(type)) {
                return AotPlaceholders.point(index);
            }
            if (Circle.class.isAssignableFrom(type)) {
                return AotPlaceholders.circle(index);
            }
            if (Box.class.isAssignableFrom(type)) {
                return AotPlaceholders.box(index);
            }
            if (Sphere.class.isAssignableFrom(type)) {
                return AotPlaceholders.sphere(index);
            }
            if (Polygon.class.isAssignableFrom(type)) {
                return AotPlaceholders.polygon(index);
            }
            if (Pattern.class.isAssignableFrom(type)) {
                return AotPlaceholders.regex(index, null);
            }
            Part partForIndex = this.getPartForIndex(partTree, parameter);
            if (partForIndex != null) {
                Part.IgnoreCaseType ignoreCaseType = partForIndex.shouldIgnoreCase();
                if (PlaceholderParameterAccessor.isLike(partForIndex.getType())) {
                    boolean ignoreCase = !ignoreCaseType.equals((Object)Part.IgnoreCaseType.NEVER);
                    return AotPlaceholders.regex(index, ignoreCase ? "i" : null);
                }
                if (PlaceholderParameterAccessor.isContaining(partForIndex.getType())) {
                    if (partForIndex.getProperty().isCollection() && !TypeInformation.of((Class)type).isCollectionLike()) {
                        if (ignoreCaseType.equals((Object)Part.IgnoreCaseType.ALWAYS)) {
                            return AotPlaceholders.asList(AotPlaceholders.regex(index, "i"));
                        }
                        return AotPlaceholders.asList(index);
                    }
                    return AotPlaceholders.indexed(index);
                }
            }
            return AotPlaceholders.indexed(index);
        }

        private static boolean isContaining(Part.Type type) {
            return type.equals((Object)Part.Type.IN) || type.equals((Object)Part.Type.NOT_IN) || type.equals((Object)Part.Type.CONTAINING) || type.equals((Object)Part.Type.NOT_CONTAINING);
        }

        private static boolean isLike(Part.Type type) {
            return type.equals((Object)Part.Type.LIKE) || type.equals((Object)Part.Type.NOT_LIKE);
        }

        @Override
        public Range<Distance> getDistanceRange() {
            return Range.unbounded();
        }

        public @Nullable Vector getVector() {
            return null;
        }

        public @Nullable Score getScore() {
            return null;
        }

        public @Nullable Range<Score> getScoreRange() {
            return null;
        }

        @Override
        public @Nullable Point getGeoNearLocation() {
            return null;
        }

        @Override
        public @Nullable TextCriteria getFullText() {
            return null;
        }

        @Override
        public @Nullable Collation getCollation() {
            return null;
        }

        @Override
        public Object[] getValues() {
            return this.placeholders.toArray();
        }

        @Override
        public @Nullable UpdateDefinition getUpdate() {
            return null;
        }

        public @Nullable ScrollPosition getScrollPosition() {
            return null;
        }

        public Pageable getPageable() {
            return null;
        }

        public Sort getSort() {
            return null;
        }

        public @Nullable Class<?> findDynamicProjection() {
            return null;
        }

        public @Nullable Object getBindableValue(int index) {
            return this.placeholders.get(index).getValue();
        }

        public boolean hasBindableNullValue() {
            return false;
        }

        public Iterator<Object> iterator() {
            return this.placeholders.iterator();
        }

        public List<AotPlaceholders.Placeholder> getPlaceholders() {
            return this.placeholders;
        }
    }

    static class AotMongoQueryCreator
    extends MongoQueryCreator {
        public AotMongoQueryCreator(PartTree tree, MongoParameterAccessor accessor, MappingContext<?, MongoPersistentProperty> context, boolean isGeoNearQuery, boolean isSearchQuery) {
            super(tree, accessor, context, isGeoNearQuery, isSearchQuery);
        }

        @Override
        protected Criteria in(Criteria criteria, Part part, Object param) {
            Criteria criteria2;
            if (param instanceof AotPlaceholders.Placeholder) {
                AotPlaceholders.Placeholder p = (AotPlaceholders.Placeholder)param;
                criteria2 = criteria.raw("$in", p);
            } else {
                criteria2 = super.in(criteria, part, param);
            }
            return criteria2;
        }

        @Override
        protected Criteria nin(Criteria criteria, Part part, Object param) {
            Criteria criteria2;
            if (param instanceof AotPlaceholders.Placeholder) {
                AotPlaceholders.Placeholder p = (AotPlaceholders.Placeholder)param;
                criteria2 = criteria.raw("$nin", p);
            } else {
                criteria2 = super.nin(criteria, part, param);
            }
            return criteria2;
        }

        @Override
        protected Criteria regex(Criteria criteria, Object param) {
            Criteria criteria2;
            if (param instanceof AotPlaceholders.Placeholder) {
                AotPlaceholders.Placeholder p = (AotPlaceholders.Placeholder)param;
                criteria2 = criteria.raw("$regex", p);
            } else {
                criteria2 = super.regex(criteria, param);
            }
            return criteria2;
        }

        @Override
        protected Criteria exists(Criteria criteria, Object param) {
            Criteria criteria2;
            if (param instanceof AotPlaceholders.Placeholder) {
                AotPlaceholders.Placeholder p = (AotPlaceholders.Placeholder)param;
                criteria2 = criteria.raw("$exists", p);
            } else {
                criteria2 = super.exists(criteria, param);
            }
            return criteria2;
        }

        @Override
        protected Criteria createContainingCriteria(Part part, MongoPersistentProperty property, Criteria criteria, Object param) {
            if (part.getType().equals((Object)Part.Type.LIKE)) {
                return criteria.is(param);
            }
            if (part.getType().equals((Object)Part.Type.NOT_LIKE)) {
                return criteria.raw("$not", param);
            }
            if (param instanceof AotPlaceholders.RegexPlaceholder) {
                return criteria.raw("$regex", param);
            }
            if (param instanceof AotPlaceholders.AsListPlaceholder) {
                AotPlaceholders.AsListPlaceholder asList = (AotPlaceholders.AsListPlaceholder)param;
                if (!property.isCollectionLike()) {
                    return super.createContainingCriteria(part, property, criteria, asList.placeholder());
                }
            }
            return super.createContainingCriteria(part, property, criteria, param);
        }
    }

    static class PlaceholderConvertingParameterAccessor
    extends ConvertingParameterAccessor {
        public PlaceholderConvertingParameterAccessor(PlaceholderParameterAccessor delegate) {
            super(PlaceholderWriter.INSTANCE, delegate);
        }
    }

    @NullUnmarked
    static enum PlaceholderWriter implements MongoWriter<Object>
    {
        INSTANCE;


        @Override
        public @Nullable Object convertToMongoType(@Nullable Object obj, @Nullable TypeInformation<?> typeInformation) {
            Object object;
            if (obj instanceof AotPlaceholders.Placeholder) {
                AotPlaceholders.Placeholder p = (AotPlaceholders.Placeholder)obj;
                object = p.getValue();
            } else {
                object = obj;
            }
            return object;
        }

        @Override
        public DBRef toDBRef(Object object, @Nullable MongoPersistentProperty referringProperty) {
            return null;
        }

        public void write(Object source, Bson sink) {
        }
    }
}

