/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import org.bson.conversions.Bson;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.ValueResolver;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;

class DefaultDbRefResolverCallback
implements DbRefResolverCallback {
    private final Bson surroundingObject;
    private final ObjectPath path;
    private final ValueResolver resolver;
    private final ValueExpressionEvaluator evaluator;

    DefaultDbRefResolverCallback(Bson surroundingObject, ObjectPath path, ValueExpressionEvaluator evaluator, ValueResolver resolver) {
        this.surroundingObject = surroundingObject;
        this.path = path;
        this.resolver = resolver;
        this.evaluator = evaluator;
    }

    @Override
    public @Nullable Object resolve(MongoPersistentProperty property) {
        return this.resolver.getValueInternal(property, this.surroundingObject, this.evaluator, this.path);
    }
}

