/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationRenderer;
import org.springframework.data.mongodb.core.aggregation.MergeOperation;
import org.springframework.data.mongodb.core.aggregation.OutOperation;
import org.springframework.data.mongodb.core.aggregation.UnionWithOperation;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class AggregationPipeline {
    private final List<AggregationOperation> pipeline;

    public static AggregationPipeline of(AggregationOperation ... stages) {
        return new AggregationPipeline(Arrays.asList(stages));
    }

    public AggregationPipeline() {
        this(new ArrayList<AggregationOperation>());
    }

    public AggregationPipeline(List<AggregationOperation> aggregationOperations) {
        Assert.notNull(aggregationOperations, (String)"AggregationOperations must not be null");
        this.pipeline = new ArrayList<AggregationOperation>(aggregationOperations);
    }

    @Contract(value="_ -> this")
    public AggregationPipeline add(AggregationOperation aggregationOperation) {
        Assert.notNull((Object)aggregationOperation, (String)"AggregationOperation must not be null");
        this.pipeline.add(aggregationOperation);
        return this;
    }

    public List<AggregationOperation> getOperations() {
        return Collections.unmodifiableList(this.pipeline);
    }

    public @Nullable AggregationOperation firstOperation() {
        return (AggregationOperation)CollectionUtils.firstElement(this.pipeline);
    }

    public @Nullable AggregationOperation lastOperation() {
        return (AggregationOperation)CollectionUtils.lastElement(this.pipeline);
    }

    List<Document> toDocuments(AggregationOperationContext context) {
        this.verify();
        return AggregationOperationRenderer.toDocument(this.pipeline, context);
    }

    public boolean isOutOrMerge() {
        if (this.isEmpty()) {
            return false;
        }
        AggregationOperation operation = this.lastOperation();
        return operation != null && (AggregationPipeline.isOut(operation) || AggregationPipeline.isMerge(operation));
    }

    void verify() {
        for (AggregationOperation operation : this.pipeline) {
            if (AggregationPipeline.isOut(operation) && !this.isLast(operation)) {
                throw new IllegalArgumentException("The $out operator must be the last stage in the pipeline");
            }
            if (!AggregationPipeline.isMerge(operation) || this.isLast(operation)) continue;
            throw new IllegalArgumentException("The $merge operator must be the last stage in the pipeline");
        }
    }

    public boolean containsUnionWith() {
        return this.containsOperation(AggregationPipeline::isUnionWith);
    }

    public boolean isEmpty() {
        return this.pipeline.isEmpty();
    }

    private boolean containsOperation(Predicate<AggregationOperation> predicate) {
        if (this.isEmpty()) {
            return false;
        }
        for (AggregationOperation element : this.pipeline) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isLast(AggregationOperation aggregationOperation) {
        return this.pipeline.indexOf(aggregationOperation) == this.pipeline.size() - 1;
    }

    private static boolean isUnionWith(AggregationOperation operator) {
        return operator instanceof UnionWithOperation || operator.getOperator().equals("$unionWith");
    }

    private static boolean isMerge(AggregationOperation operator) {
        return operator instanceof MergeOperation || operator.getOperator().equals("$merge");
    }

    private static boolean isOut(AggregationOperation operator) {
        return operator instanceof OutOperation || operator.getOperator().equals("$out");
    }
}

