/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.DecoratingProxy;
import org.springframework.data.mongodb.aot.MongoAotPredicates;
import org.springframework.data.mongodb.repository.support.CrudMethodMetadata;
import org.springframework.data.mongodb.repository.support.QuerydslMongoPredicateExecutor;
import org.springframework.data.mongodb.repository.support.ReactiveQuerydslMongoPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.util.ClassUtils;

class RepositoryRuntimeHints
implements RuntimeHintsRegistrar {
    RepositoryRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        hints.reflection().registerTypes(List.of(TypeReference.of((String)"org.springframework.data.mongodb.repository.support.SimpleMongoRepository")), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        if (RepositoryRuntimeHints.isAopPresent(classLoader)) {
            hints.proxies().registerJdkProxy(new Class[]{CrudMethodMetadata.class, SpringProxy.class, Advised.class, DecoratingProxy.class});
        }
        if (MongoAotPredicates.isReactorPresent()) {
            hints.reflection().registerTypes(List.of(TypeReference.of((String)"org.springframework.data.mongodb.repository.support.SimpleReactiveMongoRepository")), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        }
        if (QuerydslUtils.QUERY_DSL_PRESENT) {
            RepositoryRuntimeHints.registerQuerydslHints(hints, classLoader);
        }
    }

    private static void registerQuerydslHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        if (MongoAotPredicates.isReactorPresent()) {
            hints.reflection().registerType(ReactiveQuerydslMongoPredicateExecutor.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        }
        if (MongoAotPredicates.isSyncClientPresent(classLoader)) {
            hints.reflection().registerType(QuerydslMongoPredicateExecutor.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        }
    }

    private static boolean isAopPresent(@Nullable ClassLoader classLoader) {
        return ClassUtils.isPresent((String)"org.springframework.aop.Pointcut", (ClassLoader)classLoader);
    }
}

